/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.serializer.Serializer;

public abstract class BaseRepresenter {
    protected final Map<Class, Represent> representers = new HashMap<Class, Represent>();
    protected Represent nullRepresenter;
    protected final Map<Class, Represent> multiRepresenters = new HashMap<Class, Represent>();
    private Character defaultStyle;
    protected Boolean defaultFlowStyle;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>();
    private final Set<Object> objectKeeper = new HashSet<Object>();
    protected Object objectToRepresent;

    public void represent(Serializer serializer, Object object) throws IOException {
        Node node = this.representData(object);
        serializer.serialize(node);
        this.representedObjects.clear();
        this.objectKeeper.clear();
        this.objectToRepresent = null;
    }

    protected Node representData(Object object) {
        Node node;
        this.objectToRepresent = object;
        if (!this.ignoreAliases(object) && this.representedObjects.containsKey(this.objectToRepresent)) {
            Node node2 = this.representedObjects.get(this.objectToRepresent);
            return node2;
        }
        if (object == null) {
            Node node3 = this.nullRepresenter.representData(object);
            return node3;
        }
        Class<?> clazz = object.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent represent = this.representers.get(clazz);
            node = represent.representData(object);
        } else {
            Object object2;
            for (Class clazz2 : this.multiRepresenters.keySet()) {
                if (!clazz2.isInstance(object)) continue;
                Represent represent = this.multiRepresenters.get(clazz2);
                Node node4 = represent.representData(object);
                return node4;
            }
            if (clazz.isArray()) {
                throw new YAMLException("Arrays of primitives are not fully supported.");
            }
            if (this.multiRepresenters.containsKey(null)) {
                object2 = this.multiRepresenters.get(null);
                node = object2.representData(object);
            } else {
                object2 = this.representers.get(null);
                node = object2.representData(object);
            }
        }
        return node;
    }

    protected Node representScalar(String string, String string2, Character c) {
        if (c == null) {
            c = this.defaultStyle;
        }
        ScalarNode scalarNode = new ScalarNode(string, string2, null, null, c);
        this.representedObjects.put(this.objectToRepresent, scalarNode);
        return scalarNode;
    }

    protected Node representScalar(String string, String string2) {
        return this.representScalar(string, string2, null);
    }

    protected Node representSequence(String string, List<? extends Object> list, Boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        SequenceNode sequenceNode = new SequenceNode(string, arrayList, bl);
        this.representedObjects.put(this.objectToRepresent, sequenceNode);
        boolean bl2 = true;
        for (Object object : list) {
            Node node = this.representData(object);
            if (!(node instanceof ScalarNode) || ((ScalarNode)node).getStyle() != null) {
                bl2 = false;
            }
            arrayList.add(node);
        }
        if (bl == null) {
            if (this.defaultFlowStyle != null) {
                sequenceNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                sequenceNode.setFlowStyle(bl2);
            }
        }
        return sequenceNode;
    }

    protected Node representMapping(String string, Map<? extends Object, Object> map, Boolean bl) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>(map.size());
        MappingNode mappingNode = new MappingNode(string, arrayList, bl);
        this.representedObjects.put(this.objectToRepresent, mappingNode);
        boolean bl2 = true;
        for (Object object : map.keySet()) {
            Object object2 = map.get(object);
            Node node = this.representData(object);
            Node node2 = this.representData(object2);
            if (!(node instanceof ScalarNode) || ((ScalarNode)node).getStyle() != null) {
                bl2 = false;
            }
            if (!(node2 instanceof ScalarNode) || ((ScalarNode)node2).getStyle() != null) {
                bl2 = false;
            }
            arrayList.add(new NodeTuple(node, node2));
        }
        if (bl == null) {
            if (this.defaultFlowStyle != null) {
                mappingNode.setFlowStyle(this.defaultFlowStyle);
            } else {
                mappingNode.setFlowStyle(bl2);
            }
        }
        return mappingNode;
    }

    protected abstract boolean ignoreAliases(Object var1);

    public void setDefaultScalarStyle(DumperOptions.ScalarStyle scalarStyle) {
        this.defaultStyle = scalarStyle.getChar();
    }

    public void setDefaultFlowStyle(DumperOptions.FlowStyle flowStyle) {
        this.defaultFlowStyle = flowStyle.getStyleBoolean();
    }
}

