/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.Production;
import org.yaml.snakeyaml.reader.Reader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerImpl;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;
import org.yaml.snakeyaml.util.ArrayStack;

public final class ParserImpl
implements Parser {
    private static final Map<String, String> DEFAULT_TAGS = new HashMap<String, String>();
    private final Scanner scanner;
    private Event currentEvent;
    private List<Integer> yamlVersion;
    private Map<String, String> tagHandles;
    private final ArrayStack<Production> states;
    private final ArrayStack<Mark> marks;
    private Production state;

    public ParserImpl(Reader reader) {
        this.scanner = new ScannerImpl(reader);
        this.currentEvent = null;
        this.yamlVersion = null;
        this.tagHandles = new HashMap<String, String>();
        this.states = new ArrayStack(100);
        this.marks = new ArrayStack(10);
        this.state = new ParseStreamStart();
    }

    public boolean checkEvent(List<Class<? extends Event>> list) {
        this.peekEvent();
        if (this.currentEvent != null) {
            if (list.size() == 0) {
                return true;
            }
            for (Class<? extends Event> clazz : list) {
                if (!clazz.isInstance(this.currentEvent)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkEvent(Class<? extends Event> clazz) {
        ArrayList<Class<? extends Event>> arrayList = new ArrayList<Class<? extends Event>>(1);
        arrayList.add(clazz);
        return this.checkEvent(arrayList);
    }

    @Override
    public Event peekEvent() {
        if (this.currentEvent == null && this.state != null) {
            this.currentEvent = this.state.produce();
        }
        return this.currentEvent;
    }

    @Override
    public Event getEvent() {
        this.peekEvent();
        Event event = this.currentEvent;
        this.currentEvent = null;
        return event;
    }

    private List<Object> processDirectives() {
        Object object;
        this.yamlVersion = null;
        this.tagHandles = new HashMap<String, String>();
        while (this.scanner.checkToken(DirectiveToken.class)) {
            List<?> list;
            object = (DirectiveToken)this.scanner.getToken();
            if (((DirectiveToken)object).getName().equals("YAML")) {
                if (this.yamlVersion != null) {
                    throw new ParserException(null, null, "found duplicate YAML directive", ((Token)object).getStartMark());
                }
                list = ((DirectiveToken)object).getValue();
                Integer n = (Integer)list.get(0);
                if (n != 1) {
                    throw new ParserException(null, null, "found incompatible YAML document (version 1.* is required)", ((Token)object).getStartMark());
                }
                this.yamlVersion = ((DirectiveToken)object).getValue();
                continue;
            }
            if (!((DirectiveToken)object).getName().equals("TAG")) continue;
            list = ((DirectiveToken)object).getValue();
            String string = (String)list.get(0);
            String string2 = (String)list.get(1);
            if (this.tagHandles.containsKey(string)) {
                throw new ParserException(null, null, "duplicate tag handle " + string, ((Token)object).getStartMark());
            }
            this.tagHandles.put(string, string2);
        }
        object = new ArrayList(2);
        object.add(this.yamlVersion);
        if (!this.tagHandles.isEmpty()) {
            object.add(new HashMap<String, String>(this.tagHandles));
        } else {
            object.add(new HashMap());
        }
        for (String string : DEFAULT_TAGS.keySet()) {
            if (this.tagHandles.containsKey(string)) continue;
            this.tagHandles.put(string, DEFAULT_TAGS.get(string));
        }
        return object;
    }

    private Event parseFlowNode() {
        return this.parseNode(false, false);
    }

    private Event parseBlockNodeOrIndentlessSequence() {
        return this.parseNode(true, true);
    }

    private Event parseNode(boolean bl, boolean bl2) {
        NodeEvent nodeEvent;
        Mark mark = null;
        Mark mark2 = null;
        Mark mark3 = null;
        if (this.scanner.checkToken(AliasToken.class)) {
            AliasToken aliasToken = (AliasToken)this.scanner.getToken();
            nodeEvent = new AliasEvent(aliasToken.getValue(), aliasToken.getStartMark(), aliasToken.getEndMark());
            this.state = this.states.pop();
        } else {
            boolean bl3;
            Object object;
            Token token;
            Object object2;
            String string = null;
            String[] stringArray = null;
            if (this.scanner.checkToken(AnchorToken.class)) {
                object2 = (AnchorToken)this.scanner.getToken();
                mark = ((Token)object2).getStartMark();
                mark2 = ((Token)object2).getEndMark();
                string = ((AnchorToken)object2).getValue();
                if (this.scanner.checkToken(TagToken.class)) {
                    token = (TagToken)this.scanner.getToken();
                    mark3 = token.getStartMark();
                    mark2 = token.getEndMark();
                    stringArray = ((TagToken)token).getValue();
                }
            } else if (this.scanner.checkToken(TagToken.class)) {
                object2 = (TagToken)this.scanner.getToken();
                mark3 = mark = ((Token)object2).getStartMark();
                mark2 = ((Token)object2).getEndMark();
                stringArray = ((TagToken)object2).getValue();
                if (this.scanner.checkToken(AnchorToken.class)) {
                    token = (AnchorToken)this.scanner.getToken();
                    mark2 = token.getEndMark();
                    string = ((AnchorToken)token).getValue();
                }
            }
            object2 = null;
            if (stringArray != null) {
                token = stringArray[0];
                object = stringArray[1];
                if (token != null) {
                    if (!this.tagHandles.containsKey(token)) {
                        throw new ParserException("while parsing a node", mark, "found undefined tag handle " + (String)((Object)token), mark3);
                    }
                    object2 = this.tagHandles.get(token) + (String)object;
                } else {
                    object2 = object;
                }
            }
            if (mark == null) {
                mark2 = mark = this.scanner.peekToken().getStartMark();
            }
            nodeEvent = null;
            boolean bl4 = bl3 = object2 == null || ((String)object2).equals("!");
            if (bl2 && this.scanner.checkToken(BlockEntryToken.class)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new SequenceStartEvent(string, (String)object2, bl3, mark, mark2, Boolean.FALSE);
                this.state = new ParseIndentlessSequenceEntry();
            } else if (this.scanner.checkToken(ScalarToken.class)) {
                object = (ScalarToken)this.scanner.getToken();
                mark2 = ((Token)object).getEndMark();
                ImplicitTuple implicitTuple = ((ScalarToken)object).getPlain() && object2 == null || "!".equals(object2) ? new ImplicitTuple(true, false) : (object2 == null ? new ImplicitTuple(false, true) : new ImplicitTuple(false, false));
                nodeEvent = new ScalarEvent(string, (String)object2, implicitTuple, ((ScalarToken)object).getValue(), mark, mark2, Character.valueOf(((ScalarToken)object).getStyle()));
                this.state = this.states.pop();
            } else if (this.scanner.checkToken(FlowSequenceStartToken.class)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new SequenceStartEvent(string, (String)object2, bl3, mark, mark2, Boolean.TRUE);
                this.state = new ParseFlowSequenceFirstEntry();
            } else if (this.scanner.checkToken(FlowMappingStartToken.class)) {
                mark2 = this.scanner.peekToken().getEndMark();
                nodeEvent = new MappingStartEvent(string, (String)object2, bl3, mark, mark2, Boolean.TRUE);
                this.state = new ParseFlowMappingFirstKey();
            } else if (bl && this.scanner.checkToken(BlockSequenceStartToken.class)) {
                mark2 = this.scanner.peekToken().getStartMark();
                nodeEvent = new SequenceStartEvent(string, (String)object2, bl3, mark, mark2, Boolean.FALSE);
                this.state = new ParseBlockSequenceFirstEntry();
            } else if (bl && this.scanner.checkToken(BlockMappingStartToken.class)) {
                mark2 = this.scanner.peekToken().getStartMark();
                nodeEvent = new MappingStartEvent(string, (String)object2, bl3, mark, mark2, Boolean.FALSE);
                this.state = new ParseBlockMappingFirstKey();
            } else if (string != null || object2 != null) {
                nodeEvent = new ScalarEvent(string, (String)object2, new ImplicitTuple(bl3, false), "", mark, mark2, Character.valueOf('\u0000'));
                this.state = this.states.pop();
            } else {
                object = bl ? "block" : "flow";
                Token token2 = this.scanner.peekToken();
                throw new ParserException("while parsing a " + (String)object + " node", mark, "expected the node content, but found " + token2.getTokenId(), token2.getStartMark());
            }
        }
        return nodeEvent;
    }

    private Event processEmptyScalar(Mark mark) {
        return new ScalarEvent(null, null, new ImplicitTuple(true, false), "", mark, mark, Character.valueOf('\u0000'));
    }

    static {
        DEFAULT_TAGS.put("!", "!");
        DEFAULT_TAGS.put("!!", "tag:yaml.org,2002:");
    }

    private class ParseFlowMappingEmptyValue
    implements Production {
        private ParseFlowMappingEmptyValue() {
        }

        @Override
        public Event produce() {
            ParserImpl.this.state = new ParseFlowMappingKey(false);
            return ParserImpl.this.processEmptyScalar(ParserImpl.this.scanner.peekToken().getStartMark());
        }
    }

    private class ParseFlowMappingValue
    implements Production {
        private ParseFlowMappingValue() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(FlowEntryToken.class);
                arrayList.add(FlowMappingEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseFlowMappingKey(false));
                    return ParserImpl.this.parseFlowNode();
                }
                ParserImpl.this.state = new ParseFlowMappingKey(false);
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseFlowMappingKey(false);
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseFlowMappingKey
    implements Production {
        private boolean first = false;

        public ParseFlowMappingKey(boolean bl) {
            this.first = bl;
        }

        @Override
        public Event produce() {
            if (!ParserImpl.this.scanner.checkToken(FlowMappingEndToken.class)) {
                if (!this.first) {
                    if (ParserImpl.this.scanner.checkToken(FlowEntryToken.class)) {
                        ParserImpl.this.scanner.getToken();
                    } else {
                        Token token = ParserImpl.this.scanner.peekToken();
                        throw new ParserException("while parsing a flow mapping", (Mark)ParserImpl.this.marks.pop(), "expected ',' or '}', but got " + token.getTokenId(), token.getStartMark());
                    }
                }
                if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                    Token token = ParserImpl.this.scanner.getToken();
                    ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                    arrayList.add(ValueToken.class);
                    arrayList.add(FlowEntryToken.class);
                    arrayList.add(FlowMappingEndToken.class);
                    if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                        ParserImpl.this.states.push(new ParseFlowMappingValue());
                        return ParserImpl.this.parseFlowNode();
                    }
                    ParserImpl.this.state = new ParseFlowMappingValue();
                    return ParserImpl.this.processEmptyScalar(token.getEndMark());
                }
                if (!ParserImpl.this.scanner.checkToken(FlowMappingEndToken.class)) {
                    ParserImpl.this.states.push(new ParseFlowMappingEmptyValue());
                    return ParserImpl.this.parseFlowNode();
                }
            }
            Token token = ParserImpl.this.scanner.getToken();
            MappingEndEvent mappingEndEvent = new MappingEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
            ParserImpl.this.marks.pop();
            return mappingEndEvent;
        }
    }

    private class ParseFlowMappingFirstKey
    implements Production {
        private ParseFlowMappingFirstKey() {
        }

        @Override
        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.push(token.getStartMark());
            return new ParseFlowMappingKey(true).produce();
        }
    }

    private class ParseFlowSequenceEntryMappingEnd
    implements Production {
        private ParseFlowSequenceEntryMappingEnd() {
        }

        @Override
        public Event produce() {
            ParserImpl.this.state = new ParseFlowSequenceEntry(false);
            Token token = ParserImpl.this.scanner.peekToken();
            return new MappingEndEvent(token.getStartMark(), token.getEndMark());
        }
    }

    private class ParseFlowSequenceEntryMappingValue
    implements Production {
        private ParseFlowSequenceEntryMappingValue() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(FlowEntryToken.class);
                arrayList.add(FlowSequenceEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseFlowSequenceEntryMappingEnd());
                    return ParserImpl.this.parseFlowNode();
                }
                ParserImpl.this.state = new ParseFlowSequenceEntryMappingEnd();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseFlowSequenceEntryMappingEnd();
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseFlowSequenceEntryMappingKey
    implements Production {
        private ParseFlowSequenceEntryMappingKey() {
        }

        @Override
        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
            arrayList.add(ValueToken.class);
            arrayList.add(FlowEntryToken.class);
            arrayList.add(FlowSequenceEndToken.class);
            if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                ParserImpl.this.states.push(new ParseFlowSequenceEntryMappingValue());
                return ParserImpl.this.parseFlowNode();
            }
            ParserImpl.this.state = new ParseFlowSequenceEntryMappingValue();
            return ParserImpl.this.processEmptyScalar(token.getEndMark());
        }
    }

    private class ParseFlowSequenceEntry
    implements Production {
        private boolean first = false;

        public ParseFlowSequenceEntry(boolean bl) {
            this.first = bl;
        }

        @Override
        public Event produce() {
            if (!ParserImpl.this.scanner.checkToken(FlowSequenceEndToken.class)) {
                if (!this.first) {
                    if (ParserImpl.this.scanner.checkToken(FlowEntryToken.class)) {
                        ParserImpl.this.scanner.getToken();
                    } else {
                        Token token = ParserImpl.this.scanner.peekToken();
                        throw new ParserException("while parsing a flow sequence", (Mark)ParserImpl.this.marks.pop(), "expected ',' or ']', but got " + token.getTokenId(), token.getStartMark());
                    }
                }
                if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                    Token token = ParserImpl.this.scanner.peekToken();
                    MappingStartEvent mappingStartEvent = new MappingStartEvent(null, null, true, token.getStartMark(), token.getEndMark(), Boolean.TRUE);
                    ParserImpl.this.state = new ParseFlowSequenceEntryMappingKey();
                    return mappingStartEvent;
                }
                if (!ParserImpl.this.scanner.checkToken(FlowSequenceEndToken.class)) {
                    ParserImpl.this.states.push(new ParseFlowSequenceEntry(false));
                    return ParserImpl.this.parseFlowNode();
                }
            }
            Token token = ParserImpl.this.scanner.getToken();
            SequenceEndEvent sequenceEndEvent = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
            ParserImpl.this.marks.pop();
            return sequenceEndEvent;
        }
    }

    private class ParseFlowSequenceFirstEntry
    implements Production {
        private ParseFlowSequenceFirstEntry() {
        }

        @Override
        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.push(token.getStartMark());
            return new ParseFlowSequenceEntry(true).produce();
        }
    }

    private class ParseBlockMappingValue
    implements Production {
        private ParseBlockMappingValue() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(ValueToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(KeyToken.class);
                arrayList.add(ValueToken.class);
                arrayList.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseBlockMappingKey());
                    return ParserImpl.this.parseBlockNodeOrIndentlessSequence();
                }
                ParserImpl.this.state = new ParseBlockMappingKey();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            ParserImpl.this.state = new ParseBlockMappingKey();
            Token token = ParserImpl.this.scanner.peekToken();
            return ParserImpl.this.processEmptyScalar(token.getStartMark());
        }
    }

    private class ParseBlockMappingKey
    implements Production {
        private ParseBlockMappingKey() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(KeyToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(KeyToken.class);
                arrayList.add(ValueToken.class);
                arrayList.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseBlockMappingValue());
                    return ParserImpl.this.parseBlockNodeOrIndentlessSequence();
                }
                ParserImpl.this.state = new ParseBlockMappingValue();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            if (!ParserImpl.this.scanner.checkToken(BlockEndToken.class)) {
                Token token = ParserImpl.this.scanner.peekToken();
                throw new ParserException("while parsing a block mapping", (Mark)ParserImpl.this.marks.pop(), "expected <block end>, but found " + token.getTokenId(), token.getStartMark());
            }
            Token token = ParserImpl.this.scanner.getToken();
            MappingEndEvent mappingEndEvent = new MappingEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
            ParserImpl.this.marks.pop();
            return mappingEndEvent;
        }
    }

    private class ParseBlockMappingFirstKey
    implements Production {
        private ParseBlockMappingFirstKey() {
        }

        @Override
        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.push(token.getStartMark());
            return new ParseBlockMappingKey().produce();
        }
    }

    private class ParseIndentlessSequenceEntry
    implements Production {
        private ParseIndentlessSequenceEntry() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(BlockEntryToken.class)) {
                Token token = ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(BlockEntryToken.class);
                arrayList.add(KeyToken.class);
                arrayList.add(ValueToken.class);
                arrayList.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseIndentlessSequenceEntry());
                    return new ParseBlockNode().produce();
                }
                ParserImpl.this.state = new ParseIndentlessSequenceEntry();
                return ParserImpl.this.processEmptyScalar(token.getEndMark());
            }
            Token token = ParserImpl.this.scanner.peekToken();
            SequenceEndEvent sequenceEndEvent = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
            return sequenceEndEvent;
        }
    }

    private class ParseBlockSequenceEntry
    implements Production {
        private ParseBlockSequenceEntry() {
        }

        @Override
        public Event produce() {
            if (ParserImpl.this.scanner.checkToken(BlockEntryToken.class)) {
                BlockEntryToken blockEntryToken = (BlockEntryToken)ParserImpl.this.scanner.getToken();
                ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
                arrayList.add(BlockEntryToken.class);
                arrayList.add(BlockEndToken.class);
                if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                    ParserImpl.this.states.push(new ParseBlockSequenceEntry());
                    return new ParseBlockNode().produce();
                }
                ParserImpl.this.state = new ParseBlockSequenceEntry();
                return ParserImpl.this.processEmptyScalar(blockEntryToken.getEndMark());
            }
            if (!ParserImpl.this.scanner.checkToken(BlockEndToken.class)) {
                Token token = ParserImpl.this.scanner.peekToken();
                throw new ParserException("while parsing a block collection", (Mark)ParserImpl.this.marks.pop(), "expected <block end>, but found " + token.getTokenId(), token.getStartMark());
            }
            Token token = ParserImpl.this.scanner.getToken();
            SequenceEndEvent sequenceEndEvent = new SequenceEndEvent(token.getStartMark(), token.getEndMark());
            ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
            ParserImpl.this.marks.pop();
            return sequenceEndEvent;
        }
    }

    private class ParseBlockSequenceFirstEntry
    implements Production {
        private ParseBlockSequenceFirstEntry() {
        }

        @Override
        public Event produce() {
            Token token = ParserImpl.this.scanner.getToken();
            ParserImpl.this.marks.push(token.getStartMark());
            return new ParseBlockSequenceEntry().produce();
        }
    }

    private class ParseBlockNode
    implements Production {
        private ParseBlockNode() {
        }

        @Override
        public Event produce() {
            return ParserImpl.this.parseNode(true, false);
        }
    }

    private class ParseDocumentContent
    implements Production {
        private ParseDocumentContent() {
        }

        @Override
        public Event produce() {
            ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
            arrayList.add(DirectiveToken.class);
            arrayList.add(DocumentStartToken.class);
            arrayList.add(DocumentEndToken.class);
            arrayList.add(StreamEndToken.class);
            if (ParserImpl.this.scanner.checkToken(arrayList)) {
                Event event = ParserImpl.this.processEmptyScalar(ParserImpl.this.scanner.peekToken().getStartMark());
                ParserImpl.this.state = (Production)ParserImpl.this.states.pop();
                return event;
            }
            ParseBlockNode parseBlockNode = new ParseBlockNode();
            return parseBlockNode.produce();
        }
    }

    private class ParseDocumentEnd
    implements Production {
        private ParseDocumentEnd() {
        }

        @Override
        public Event produce() {
            Mark mark;
            Token token = ParserImpl.this.scanner.peekToken();
            Mark mark2 = mark = token.getStartMark();
            boolean bl = false;
            if (ParserImpl.this.scanner.checkToken(DocumentEndToken.class)) {
                token = ParserImpl.this.scanner.getToken();
                mark2 = token.getEndMark();
                bl = true;
            }
            DocumentEndEvent documentEndEvent = new DocumentEndEvent(mark, mark2, bl);
            ParserImpl.this.state = new ParseDocumentStart();
            return documentEndEvent;
        }
    }

    private class ParseDocumentStart
    implements Production {
        private ParseDocumentStart() {
        }

        @Override
        public Event produce() {
            Event event;
            while (ParserImpl.this.scanner.checkToken(DocumentEndToken.class)) {
                ParserImpl.this.scanner.getToken();
            }
            if (!ParserImpl.this.scanner.checkToken(StreamEndToken.class)) {
                Integer[] integerArray;
                Token token = ParserImpl.this.scanner.peekToken();
                Mark mark = token.getStartMark();
                List list = ParserImpl.this.processDirectives();
                List list2 = (List)list.get(0);
                Map map = (Map)list.get(1);
                if (!ParserImpl.this.scanner.checkToken(DocumentStartToken.class)) {
                    throw new ParserException(null, null, "expected '<document start>', but found " + ParserImpl.this.scanner.peekToken().getTokenId(), ParserImpl.this.scanner.peekToken().getStartMark());
                }
                token = ParserImpl.this.scanner.getToken();
                Mark mark2 = token.getEndMark();
                if (list2 != null) {
                    integerArray = new Integer[2];
                    integerArray = list2.toArray(integerArray);
                } else {
                    integerArray = null;
                }
                event = new DocumentStartEvent(mark, mark2, true, integerArray, map);
                ParserImpl.this.states.push(new ParseDocumentEnd());
                ParserImpl.this.state = new ParseDocumentContent();
            } else {
                StreamEndToken streamEndToken = (StreamEndToken)ParserImpl.this.scanner.getToken();
                event = new StreamEndEvent(streamEndToken.getStartMark(), streamEndToken.getEndMark());
                if (!ParserImpl.this.states.isEmpty()) {
                    throw new YAMLException("Unexpected end of stream. States left: " + ParserImpl.this.states);
                }
                if (!ParserImpl.this.marks.isEmpty()) {
                    throw new YAMLException("Unexpected end of stream. Marks left: " + ParserImpl.this.marks);
                }
                ParserImpl.this.state = null;
            }
            return event;
        }
    }

    private class ParseImplicitDocumentStart
    implements Production {
        private ParseImplicitDocumentStart() {
        }

        @Override
        public Event produce() {
            ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
            arrayList.add(DirectiveToken.class);
            arrayList.add(DocumentStartToken.class);
            arrayList.add(StreamEndToken.class);
            if (!ParserImpl.this.scanner.checkToken(arrayList)) {
                Mark mark;
                ParserImpl.this.tagHandles = DEFAULT_TAGS;
                Token token = ParserImpl.this.scanner.peekToken();
                Mark mark2 = mark = token.getStartMark();
                DocumentStartEvent documentStartEvent = new DocumentStartEvent(mark, mark2, false, null, null);
                ParserImpl.this.states.push(new ParseDocumentEnd());
                ParserImpl.this.state = new ParseBlockNode();
                return documentStartEvent;
            }
            ParseDocumentStart parseDocumentStart = new ParseDocumentStart();
            return parseDocumentStart.produce();
        }
    }

    private class ParseStreamStart
    implements Production {
        private ParseStreamStart() {
        }

        @Override
        public Event produce() {
            StreamStartToken streamStartToken = (StreamStartToken)ParserImpl.this.scanner.getToken();
            StreamStartEvent streamStartEvent = new StreamStartEvent(streamStartToken.getStartMark(), streamStartToken.getEndMark());
            ParserImpl.this.state = new ParseImplicitDocumentStart();
            return streamStartEvent;
        }
    }
}

