/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import java.util.List;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;

public class MappingNode
extends CollectionNode {
    private Class<? extends Object> keyType;
    private Class<? extends Object> valueType;
    private List<NodeTuple> value;

    public MappingNode(String string, boolean bl, List<NodeTuple> list, Mark mark, Mark mark2, Boolean bl2) {
        super(string, mark, mark2, bl2);
        if (list == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = list;
        this.keyType = Object.class;
        this.valueType = Object.class;
        this.resolved = bl;
    }

    public MappingNode(String string, List<NodeTuple> list, Boolean bl) {
        this(string, true, list, null, null, bl);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.mapping;
    }

    public List<NodeTuple> getValue() {
        for (NodeTuple nodeTuple : this.value) {
            nodeTuple.getKeyNode().setType(this.keyType);
            nodeTuple.getValueNode().setType(this.valueType);
        }
        return this.value;
    }

    public void setValue(List<NodeTuple> list) {
        this.value = list;
    }

    public void setKeyType(Class<? extends Object> clazz) {
        this.keyType = clazz;
    }

    public void setValueType(Class<? extends Object> clazz) {
        this.valueType = clazz;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (NodeTuple nodeTuple : this.getValue()) {
            stringBuffer.append("{ key=");
            stringBuffer.append(nodeTuple.getKeyNode());
            stringBuffer.append("; value=Node<");
            stringBuffer.append(System.identityHashCode(nodeTuple.getValueNode()));
            stringBuffer.append("> }");
        }
        String string = stringBuffer.toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + string + ")>";
    }
}

