/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.yaml.snakeyaml.Dumper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.resolver.Resolver;

public class Yaml {
    private final Dumper dumper;
    private final Loader loader;
    private final Resolver resolver;
    private String name;

    public Yaml(DumperOptions dumperOptions) {
        this(new Loader(), new Dumper(dumperOptions));
    }

    public Yaml(Loader loader, Dumper dumper) {
        this(loader, dumper, new Resolver());
    }

    public Yaml(Loader loader, Dumper dumper, Resolver resolver) {
        this.loader = loader;
        loader.setAttached();
        this.dumper = dumper;
        dumper.setAttached();
        this.resolver = resolver;
        this.loader.setResolver(resolver);
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    public Yaml() {
        this(new Loader(), new Dumper(new DumperOptions()));
    }

    public void dump(Object object, Writer writer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.dumpAll(arrayList.iterator(), writer);
    }

    public void dumpAll(Iterator<? extends Object> iterator, Writer writer) {
        this.dumper.dump(iterator, writer, this.resolver);
    }

    public Object load(InputStream inputStream) {
        return this.loader.load(new UnicodeReader(inputStream));
    }

    public String toString() {
        return this.name;
    }
}

