/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.wrapper.classic;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.XmlSerializerWrapper;
import org.xmlpull.v1.wrapper.classic.XmlSerializerDelegate;

public class StaticXmlSerializerWrapper
extends XmlSerializerDelegate
implements XmlSerializerWrapper {
    protected XmlPullWrapperFactory wf;
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected int[] namespaceDepth = new int[this.namespacePrefix.length];

    public StaticXmlSerializerWrapper(XmlSerializer xmlSerializer, XmlPullWrapperFactory xmlPullWrapperFactory) {
        super(xmlSerializer);
        this.wf = xmlPullWrapperFactory;
    }

    private void ensureNamespacesCapacity() {
        int n = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceDepth, 0, nArray, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
        this.namespaceDepth = nArray;
    }

    @Override
    public void setPrefix(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        this.xs.setPrefix(string, string2);
        int n = this.getDepth();
        for (int i = this.namespaceEnd - 1; i >= 0 && this.namespaceDepth[i] > n; --i) {
            --this.namespaceEnd;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
    }

    @Override
    public void event(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)xmlPullParser.getProperty("http://xmlpull.org/v1/doc/features.html#xmldecl-standalone");
                this.startDocument(xmlPullParser.getInputEncoding(), bl);
                break;
            }
            case 1: {
                this.endDocument();
                break;
            }
            case 2: {
                this.writeStartTag(xmlPullParser);
                break;
            }
            case 3: {
                this.endTag(xmlPullParser.getNamespace(), xmlPullParser.getName());
                break;
            }
            case 7: {
                String string = xmlPullParser.getText();
                this.ignorableWhitespace(string);
                break;
            }
            case 4: {
                if (xmlPullParser.getDepth() > 0) {
                    this.text(xmlPullParser.getText());
                    break;
                }
                this.ignorableWhitespace(xmlPullParser.getText());
                break;
            }
            case 6: {
                this.entityRef(xmlPullParser.getName());
                break;
            }
            case 5: {
                this.cdsect(xmlPullParser.getText());
                break;
            }
            case 8: {
                this.processingInstruction(xmlPullParser.getText());
                break;
            }
            case 9: {
                this.comment(xmlPullParser.getText());
                break;
            }
            case 10: {
                this.docdecl(xmlPullParser.getText());
            }
        }
    }

    private void writeStartTag(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        if (!xmlPullParser.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
            n = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1);
            int n2 = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth());
            for (int i = n; i < n2; ++i) {
                String string = xmlPullParser.getNamespacePrefix(i);
                String string2 = xmlPullParser.getNamespaceUri(i);
                this.setPrefix(string, string2);
            }
        }
        this.startTag(xmlPullParser.getNamespace(), xmlPullParser.getName());
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            this.attribute(xmlPullParser.getAttributeNamespace(n), xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeValue(n));
        }
    }
}

