/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.Util.SparseArray;

public enum ValueType {
    VALUE_BYTE(0),
    VALUE_SHORT(2),
    VALUE_CHAR(3),
    VALUE_INT(4),
    VALUE_LONG(6),
    VALUE_FLOAT(16),
    VALUE_DOUBLE(17),
    VALUE_STRING(23),
    VALUE_TYPE(24),
    VALUE_FIELD(25),
    VALUE_METHOD(26),
    VALUE_ENUM(27),
    VALUE_ARRAY(28),
    VALUE_ANNOTATION(29),
    VALUE_NULL(30),
    VALUE_BOOLEAN(31);

    private static final SparseArray<ValueType> valueTypeIntegerMap;
    public final byte value;

    private ValueType(byte by) {
        this.value = by;
    }

    public static ValueType fromByte(byte by) {
        return valueTypeIntegerMap.get(by);
    }

    static {
        valueTypeIntegerMap = new SparseArray(16);
        for (ValueType valueType : ValueType.values()) {
            valueTypeIntegerMap.put(valueType.value, valueType);
        }
    }
}

