/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class LongEncodedValue
extends EncodedValue {
    public final long value;

    protected LongEncodedValue(Input input, byte by) {
        this.value = EncodedValueUtils.decodeSignedIntegralValue(input.readBytes(by + 1));
    }

    public LongEncodedValue(long l) {
        this.value = l;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeSignedIntegralValue(this.value);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_LONG.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: 0x" + Long.toHexString(this.value) + " (" + this.value + ")");
        }
        annotatedOutput.writeByte(ValueType.VALUE_LONG.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + EncodedValueUtils.getRequiredBytesForSignedIntegralValue(this.value) + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        LongEncodedValue longEncodedValue = (LongEncodedValue)encodedValue;
        return this.value < longEncodedValue.value ? -1 : (this.value > longEncodedValue.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_LONG;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

