/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;

public class BooleanEncodedValue
extends EncodedValue {
    public static final BooleanEncodedValue TrueValue = new BooleanEncodedValue(true);
    public static final BooleanEncodedValue FalseValue = new BooleanEncodedValue(false);
    public final boolean value;

    private BooleanEncodedValue(boolean bl) {
        this.value = bl;
    }

    protected static BooleanEncodedValue getBooleanEncodedValue(byte by) {
        if (by == 0) {
            return FalseValue;
        }
        if (by == 1) {
            return TrueValue;
        }
        throw new RuntimeException("valueArg must be either 0 or 1");
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate("value_type=" + ValueType.VALUE_BOOLEAN.name() + ",value=" + Boolean.toString(this.value));
        }
        annotatedOutput.writeByte(ValueType.VALUE_BOOLEAN.value | (this.value ? 1 : 0) << 5);
    }

    @Override
    public int placeValue(int n) {
        return n + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        BooleanEncodedValue booleanEncodedValue = (BooleanEncodedValue)encodedValue;
        if (this.value == booleanEncodedValue.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_BOOLEAN;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }
}

