/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction3rms
extends Instruction
implements OdexedInvokeVirtual,
RegisterRangeInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private short startReg;
    private short methodIndex;

    private Instruction3rms(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regCount = (byte)NumberUtils.decodeUnsignedByte(byArray[n + 1]);
        this.methodIndex = (short)NumberUtils.decodeUnsignedShort(byArray, n + 2);
        this.startReg = (short)NumberUtils.decodeUnsignedShort(byArray, n + 4);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regCount);
        annotatedOutput.writeShort(this.methodIndex);
        annotatedOutput.writeShort(this.startReg);
    }

    @Override
    public Format getFormat() {
        return Format.Format3rms;
    }

    @Override
    public short getRegCount() {
        return (short)(this.regCount & 0xFF);
    }

    @Override
    public int getStartRegister() {
        return this.startReg & 0xFFFF;
    }

    @Override
    public int getMethodIndex() {
        return this.methodIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction3rms(opcode, byArray, n);
        }
    }
}

