/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction35ms
extends Instruction
implements FiveRegisterInstruction,
OdexedInvokeVirtual {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regCount;
    private byte regA;
    private byte regD;
    private byte regE;
    private byte regF;
    private byte regG;
    private short methodIndex;

    private Instruction35ms(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regCount = NumberUtils.decodeHighUnsignedNibble(byArray[n + 1]);
        this.regA = NumberUtils.decodeLowUnsignedNibble(byArray[n + 1]);
        this.regD = NumberUtils.decodeLowUnsignedNibble(byArray[n + 4]);
        this.regE = NumberUtils.decodeHighUnsignedNibble(byArray[n + 4]);
        this.regF = NumberUtils.decodeLowUnsignedNibble(byArray[n + 5]);
        this.regG = NumberUtils.decodeHighUnsignedNibble(byArray[n + 5]);
        this.methodIndex = (short)NumberUtils.decodeUnsignedShort(byArray, n + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regCount << 4 | this.regA);
        annotatedOutput.writeShort(this.methodIndex);
        annotatedOutput.writeByte(this.regE << 4 | this.regD);
        annotatedOutput.writeByte(this.regG << 4 | this.regF);
    }

    @Override
    public Format getFormat() {
        return Format.Format35ms;
    }

    @Override
    public byte getRegCount() {
        return this.regCount;
    }

    @Override
    public byte getRegisterA() {
        return this.regA;
    }

    @Override
    public byte getRegisterD() {
        return this.regD;
    }

    @Override
    public byte getRegisterE() {
        return this.regE;
    }

    @Override
    public byte getRegisterF() {
        return this.regF;
    }

    @Override
    public byte getRegisterG() {
        return this.regG;
    }

    @Override
    public int getMethodIndex() {
        return this.methodIndex & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction35ms(opcode, byArray, n);
        }
    }
}

