/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction23x
extends Instruction
implements ThreeRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private byte regC;

    public Instruction23x(Opcode opcode, short s, short s2, short s3) {
        super(opcode);
        if (s >= 256 || s2 >= 256 || s3 >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)s;
        this.regB = (byte)s2;
        this.regC = (byte)s3;
    }

    private Instruction23x(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = byArray[n + 1];
        this.regB = byArray[n + 2];
        this.regC = byArray[n + 3];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeByte(this.regB);
        annotatedOutput.writeByte(this.regC);
    }

    @Override
    public Format getFormat() {
        return Format.Format23x;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFF;
    }

    @Override
    public int getRegisterC() {
        return this.regC & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction23x(opcode, byArray, n);
        }
    }
}

