/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;

public class Instruction21c
extends InstructionWithReference
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;

    public Instruction21c(Opcode opcode, short s, Item item) {
        super(opcode, item);
        if (s >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        if (opcode == Opcode.NEW_INSTANCE) {
            assert (item instanceof TypeIdItem);
            if (((TypeIdItem)item).getTypeDescriptor().charAt(0) != 'L') {
                throw new RuntimeException("Only class references can be used with the new-instance opcode");
            }
        }
        this.regA = (byte)s;
    }

    private Instruction21c(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
        super(dexFile, opcode, byArray, n);
        if (opcode == Opcode.NEW_INSTANCE && ((TypeIdItem)this.getReferencedItem()).getTypeDescriptor().charAt(0) != 'L') {
            throw new RuntimeException("Only class references can be used with the new-instance opcode");
        }
        this.regA = byArray[n + 1];
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        if (this.opcode == Opcode.CONST_STRING && this.getReferencedItem().getIndex() > 65535) {
            throw new RuntimeException("String offset is too large for const-string. Use string-const/jumbo instead.");
        }
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeShort(this.getReferencedItem().getIndex());
    }

    @Override
    public Format getFormat() {
        return Format.Format21c;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction21c(dexFile, opcode, byArray, n);
        }
    }
}

