/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.OdexDependencies;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

public class ClassPath {
    public static boolean dontLoadClassPath = false;
    private static ClassPath theClassPath = null;
    private final HashMap<String, ClassDef> classDefs = new HashMap();
    protected ClassDef javaLangObjectClassDef;
    private LinkedHashMap<String, TempClassInfo> tempClasses;
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");

    public static void InitializeClassPathFromOdex(String[] stringArray, String[] stringArray2, String string, DexFile dexFile, ClassPathErrorHandler classPathErrorHandler) {
        if (!dexFile.isOdex()) {
            throw new ExceptionWithContext("Cannot use InitialiazeClassPathFromOdex with a non-odex DexFile");
        }
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        OdexDependencies odexDependencies = dexFile.getOdexDependencies();
        String[] stringArray3 = new String[odexDependencies.getDependencyCount()];
        for (int i = 0; i < stringArray3.length; ++i) {
            String string2 = odexDependencies.getDependency(i);
            if (string2.endsWith(".odex")) {
                int n = string2.lastIndexOf("/");
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
            } else if (string2.endsWith("@classes.dex")) {
                Matcher matcher = dalvikCacheOdexPattern.matcher(string2);
                if (!matcher.find()) {
                    throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", string2));
                }
                string2 = matcher.group(1);
            } else {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", string2));
            }
            stringArray3[i] = string2;
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(stringArray, stringArray3, stringArray2, string, dexFile, classPathErrorHandler);
    }

    public static void InitializeClassPath(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, DexFile dexFile, ClassPathErrorHandler classPathErrorHandler) {
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(stringArray, stringArray2, stringArray3, string, dexFile, classPathErrorHandler);
    }

    private ClassPath() {
    }

    private void initClassPath(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, DexFile dexFile, ClassPathErrorHandler classPathErrorHandler) {
        this.tempClasses = new LinkedHashMap();
        if (stringArray2 != null) {
            for (String object : stringArray2) {
                this.loadBootClassPath(stringArray, object);
            }
        }
        if (stringArray3 != null) {
            for (String string2 : stringArray3) {
                this.loadBootClassPath(stringArray, string2);
            }
        }
        if (dexFile != null) {
            this.loadDexFile(string, dexFile);
        }
        for (String string2 : this.tempClasses.keySet()) {
            ClassDef classDef = null;
            try {
                classDef = ClassPath.loadClassDef(string2);
                assert (classDef != null);
            }
            catch (Exception exception) {
                if (classPathErrorHandler != null) {
                    classPathErrorHandler.ClassPathError(string2, exception);
                }
                throw ExceptionWithContext.withContext(exception, String.format("Error while loading ClassPath class %s", string2));
            }
            if (!string2.equals("Ljava/lang/Object;")) continue;
            this.javaLangObjectClassDef = classDef;
        }
        for (String string3 : new String[]{"Z", "B", "S", "C", "I", "J", "F", "D"}) {
            PrimitiveClassDef primitiveClassDef = new PrimitiveClassDef(string3);
            this.classDefs.put(string3, primitiveClassDef);
        }
        this.tempClasses = null;
    }

    private void loadBootClassPath(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            File file = null;
            DexFile dexFile = null;
            int n = string.lastIndexOf(".");
            String string3 = n == -1 ? string : string.substring(0, n);
            for (String string4 : new String[]{"", ".odex", ".jar", ".apk", ".zip"}) {
                file = string4.length() == 0 ? new File(string2, string) : new File(string2, string3 + string4);
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    continue;
                }
                try {
                    dexFile = new DexFile(file, false, true);
                }
                catch (DexFile.NoClassesDexException noClassesDexException) {
                }
                catch (Exception exception) {
                    throw ExceptionWithContext.withContext(exception, "Error while reading boot class path entry \"" + string + "\".");
                }
            }
            if (dexFile == null) continue;
            try {
                this.loadDexFile(file.getPath(), dexFile);
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, String.format("Error while loading boot classpath entry %s", string));
            }
            return;
        }
        throw new ExceptionWithContext(String.format("Cannot locate boot class path file %s", string));
    }

    private void loadDexFile(String string, DexFile dexFile) {
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            try {
                TempClassInfo tempClassInfo = new TempClassInfo(string, classDefItem);
                this.tempClasses.put(tempClassInfo.classType, tempClassInfo);
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, String.format("Error while loading class %s", classDefItem.getClassType().getTypeDescriptor()));
            }
        }
    }

    public static ClassDef getClassDef(String string) {
        return ClassPath.getClassDef(string, true);
    }

    private static ClassDef loadClassDef(String string) {
        ClassDef classDef = ClassPath.getClassDef(string, false);
        if (classDef == null) {
            TempClassInfo tempClassInfo = ClassPath.theClassPath.tempClasses.get(string);
            if (tempClassInfo == null) {
                return null;
            }
            try {
                classDef = new ClassDef(tempClassInfo);
                ClassPath.theClassPath.classDefs.put(classDef.classType, classDef);
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, String.format("Error while loading class %s from file %s", tempClassInfo.classType, tempClassInfo.dexFilePath));
            }
        }
        return classDef;
    }

    public static ClassDef getClassDef(String string, boolean bl) {
        if (dontLoadClassPath) {
            return null;
        }
        ClassDef classDef = ClassPath.theClassPath.classDefs.get(string);
        if (classDef == null) {
            if (string.charAt(0) == '[') {
                return theClassPath.createArrayClassDef(string);
            }
            if (bl) {
                return theClassPath.createUnresolvedClassDef(string);
            }
            return null;
        }
        return classDef;
    }

    public static ClassDef getClassDef(TypeIdItem typeIdItem) {
        return ClassPath.getClassDef(typeIdItem.getTypeDescriptor());
    }

    public static ClassDef getClassDef(TypeIdItem typeIdItem, boolean bl) {
        return ClassPath.getClassDef(typeIdItem.getTypeDescriptor(), bl);
    }

    private static ClassDef getArrayClassDefByElementClassAndDimension(ClassDef classDef, int n) {
        return ClassPath.getClassDef("[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[".substring(256 - n) + classDef.classType);
    }

    private ClassDef createUnresolvedClassDef(String string) {
        assert (string.charAt(0) == 'L');
        UnresolvedClassDef unresolvedClassDef = new UnresolvedClassDef(string);
        this.classDefs.put(string, unresolvedClassDef);
        return unresolvedClassDef;
    }

    private ClassDef createArrayClassDef(String string) {
        assert (string != null);
        assert (string.charAt(0) == '[');
        ArrayClassDef arrayClassDef = new ArrayClassDef(string);
        if (arrayClassDef.elementClass == null) {
            return null;
        }
        this.classDefs.put(string, arrayClassDef);
        return arrayClassDef;
    }

    public static ClassDef getCommonSuperclass(ClassDef classDef, ClassDef classDef2) {
        int n;
        if (classDef == classDef2) {
            return classDef;
        }
        if (classDef == null) {
            return classDef2;
        }
        if (classDef2 == null) {
            return classDef;
        }
        if (classDef2.isInterface) {
            if (classDef.implementsInterface(classDef2)) {
                return classDef2;
            }
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (classDef.isInterface) {
            if (classDef2.implementsInterface(classDef)) {
                return classDef;
            }
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (classDef instanceof ArrayClassDef && classDef2 instanceof ArrayClassDef) {
            return ClassPath.getCommonArraySuperclass((ArrayClassDef)classDef, (ArrayClassDef)classDef2);
        }
        int n2 = classDef2.getClassDepth();
        for (n = classDef.getClassDepth(); n > n2; --n) {
            classDef = classDef.superclass;
        }
        while (n2 > n) {
            classDef2 = classDef2.superclass;
            --n2;
        }
        while (n > 0) {
            if (classDef == classDef2) {
                return classDef;
            }
            classDef = classDef.superclass;
            --n;
            classDef2 = classDef2.superclass;
            --n2;
        }
        return classDef;
    }

    private static ClassDef getCommonArraySuperclass(ArrayClassDef arrayClassDef, ArrayClassDef arrayClassDef2) {
        assert (arrayClassDef != arrayClassDef2);
        if (arrayClassDef.elementClass instanceof PrimitiveClassDef || arrayClassDef2.elementClass instanceof PrimitiveClassDef) {
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (arrayClassDef.arrayDimensions == arrayClassDef2.arrayDimensions) {
            ClassDef classDef = ClassPath.getCommonSuperclass(arrayClassDef.elementClass, arrayClassDef2.elementClass);
            return ClassPath.getArrayClassDefByElementClassAndDimension(classDef, arrayClassDef.arrayDimensions);
        }
        int n = Math.min(arrayClassDef.arrayDimensions, arrayClassDef2.arrayDimensions);
        return ClassPath.getArrayClassDefByElementClassAndDimension(ClassPath.theClassPath.javaLangObjectClassDef, n);
    }

    private static class TempClassInfo {
        public final String dexFilePath;
        public final String classType;
        public final boolean isInterface;
        public final String superclassType;
        public final String[] interfaces;
        public final String[] virtualMethods;
        public final String[][] instanceFields;

        public TempClassInfo(String string, ClassDefItem classDefItem) {
            this.dexFilePath = string;
            this.classType = classDefItem.getClassType().getTypeDescriptor();
            this.isInterface = (classDefItem.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
            TypeIdItem typeIdItem = classDefItem.getSuperclass();
            this.superclassType = typeIdItem == null ? null : typeIdItem.getTypeDescriptor();
            this.interfaces = this.loadInterfaces(classDefItem);
            ClassDataItem classDataItem = classDefItem.getClassData();
            if (classDataItem != null) {
                this.virtualMethods = this.loadVirtualMethods(classDataItem);
                this.instanceFields = this.loadInstanceFields(classDataItem);
            } else {
                this.virtualMethods = null;
                this.instanceFields = null;
            }
        }

        private String[] loadInterfaces(ClassDefItem classDefItem) {
            List<TypeIdItem> list;
            TypeListItem typeListItem = classDefItem.getInterfaces();
            if (typeListItem != null && (list = typeListItem.getTypes()) != null && list.size() > 0) {
                String[] stringArray = new String[list.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = list.get(i).getTypeDescriptor();
                }
                return stringArray;
            }
            return null;
        }

        private String[] loadVirtualMethods(ClassDataItem classDataItem) {
            ClassDataItem.EncodedMethod[] encodedMethodArray = classDataItem.getVirtualMethods();
            if (encodedMethodArray != null && encodedMethodArray.length > 0) {
                String[] stringArray = new String[encodedMethodArray.length];
                for (int i = 0; i < encodedMethodArray.length; ++i) {
                    stringArray[i] = encodedMethodArray[i].method.getVirtualMethodString();
                }
                return stringArray;
            }
            return null;
        }

        private String[][] loadInstanceFields(ClassDataItem classDataItem) {
            ClassDataItem.EncodedField[] encodedFieldArray = classDataItem.getInstanceFields();
            if (encodedFieldArray != null && encodedFieldArray.length > 0) {
                String[][] stringArray = new String[encodedFieldArray.length][2];
                for (int i = 0; i < encodedFieldArray.length; ++i) {
                    ClassDataItem.EncodedField encodedField = encodedFieldArray[i];
                    stringArray[i][0] = encodedField.field.getFieldName().getStringValue();
                    stringArray[i][1] = encodedField.field.getFieldType().getTypeDescriptor();
                }
                return stringArray;
            }
            return null;
        }
    }

    public static class ClassDef
    implements Comparable<ClassDef> {
        private final String classType;
        private final ClassDef superclass;
        private final TreeSet<ClassDef> implementedInterfaces;
        private final boolean isInterface;
        private final int classDepth;
        private final String[] vtable;
        private final HashMap<String, Integer> virtualMethodLookup;
        private final SparseArray<String> instanceFields;
        private final HashMap<String, Integer> instanceFieldLookup;
        private String[] virtualMethods;
        private LinkedHashMap<String, ClassDef> interfaceTable;

        protected ClassDef(String string, int n) {
            if (n == 0) {
                assert (string.charAt(0) == '[');
                this.classType = string;
                this.superclass = theClassPath.javaLangObjectClassDef;
                this.implementedInterfaces = new TreeSet();
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/lang/Cloneable;"));
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/io/Serializable;"));
                this.isInterface = false;
                this.vtable = this.superclass.vtable;
                this.virtualMethodLookup = this.superclass.virtualMethodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.instanceFieldLookup = this.superclass.instanceFieldLookup;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else if (n == 1) {
                assert (string.charAt(0) != '[' && string.charAt(0) != 'L');
                this.classType = string;
                this.superclass = null;
                this.implementedInterfaces = null;
                this.isInterface = false;
                this.vtable = null;
                this.virtualMethodLookup = null;
                this.instanceFields = null;
                this.instanceFieldLookup = null;
                this.classDepth = 0;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else {
                assert (string.charAt(0) == 'L');
                this.classType = string;
                this.superclass = theClassPath.javaLangObjectClassDef;
                this.implementedInterfaces = new TreeSet();
                this.isInterface = false;
                this.vtable = this.superclass.vtable;
                this.virtualMethodLookup = this.superclass.virtualMethodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.instanceFieldLookup = this.superclass.instanceFieldLookup;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            }
        }

        protected ClassDef(TempClassInfo tempClassInfo) {
            int n;
            this.classType = tempClassInfo.classType;
            this.isInterface = tempClassInfo.isInterface;
            this.superclass = this.loadSuperclass(tempClassInfo);
            this.classDepth = this.superclass == null ? 0 : this.superclass.classDepth + 1;
            this.implementedInterfaces = this.loadAllImplementedInterfaces(tempClassInfo);
            this.interfaceTable = this.loadInterfaceTable(tempClassInfo);
            this.virtualMethods = tempClassInfo.virtualMethods;
            this.vtable = this.loadVtable(tempClassInfo);
            this.virtualMethodLookup = new HashMap((int)Math.ceil((float)this.vtable.length / 0.7f), 0.75f);
            for (n = 0; n < this.vtable.length; ++n) {
                this.virtualMethodLookup.put(this.vtable[n], n);
            }
            this.instanceFields = this.loadFields(tempClassInfo);
            this.instanceFieldLookup = new HashMap((int)Math.ceil((float)this.instanceFields.size() / 0.7f), 0.75f);
            for (n = 0; n < this.instanceFields.size(); ++n) {
                this.instanceFieldLookup.put(this.instanceFields.get(n), n);
            }
        }

        public String getClassType() {
            return this.classType;
        }

        public ClassDef getSuperclass() {
            return this.superclass;
        }

        public int getClassDepth() {
            return this.classDepth;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean extendsClass(ClassDef classDef) {
            if (classDef == null) {
                return false;
            }
            if (this == classDef) {
                return true;
            }
            if (classDef instanceof UnresolvedClassDef) {
                throw ((UnresolvedClassDef)classDef).unresolvedValidationException();
            }
            int n = classDef.classDepth;
            ClassDef classDef2 = this;
            while (classDef2.classDepth > n) {
                classDef2 = classDef2.getSuperclass();
            }
            return classDef2 == classDef;
        }

        public boolean implementsInterface(ClassDef classDef) {
            assert (!(classDef instanceof UnresolvedClassDef));
            return this.implementedInterfaces.contains(classDef);
        }

        public boolean hasVirtualMethod(String string) {
            return this.virtualMethodLookup.containsKey(string);
        }

        public String getInstanceField(int n) {
            return this.instanceFields.get(n, null);
        }

        public String getVirtualMethod(int n) {
            if (n < 0 || n >= this.vtable.length) {
                return null;
            }
            return this.vtable[n];
        }

        private void swap(byte[] byArray, String[] stringArray, int n, int n2) {
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
            String string = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string;
        }

        private ClassDef loadSuperclass(TempClassInfo tempClassInfo) {
            if (tempClassInfo.classType.equals("Ljava/lang/Object;")) {
                if (tempClassInfo.superclassType != null) {
                    throw new ExceptionWithContext("Invalid superclass " + tempClassInfo.superclassType + " for Ljava/lang/Object;. " + "The Object class cannot have a superclass");
                }
                return null;
            }
            String string = tempClassInfo.superclassType;
            if (string == null) {
                throw new ExceptionWithContext(tempClassInfo.classType + " has no superclass");
            }
            ClassDef classDef = ClassPath.loadClassDef(string);
            if (classDef == null) {
                throw new ClassNotFoundException(String.format("Could not find superclass %s", string));
            }
            if (!this.isInterface && classDef.isInterface) {
                throw new ValidationException("Class " + this.classType + " has the interface " + classDef.classType + " as its superclass");
            }
            if (this.isInterface && !classDef.isInterface && classDef != theClassPath.javaLangObjectClassDef) {
                throw new ValidationException("Interface " + this.classType + " has the non-interface class " + classDef.classType + " as its superclass");
            }
            return classDef;
        }

        private TreeSet<ClassDef> loadAllImplementedInterfaces(TempClassInfo tempClassInfo) {
            assert (this.classType != null);
            assert (this.classType.equals("Ljava/lang/Object;") || this.superclass != null);
            assert (tempClassInfo != null);
            TreeSet<ClassDef> treeSet = new TreeSet<ClassDef>();
            if (this.superclass != null) {
                for (ClassDef classDef : this.superclass.implementedInterfaces) {
                    treeSet.add(classDef);
                }
            }
            if (tempClassInfo.interfaces != null) {
                for (String string : tempClassInfo.interfaces) {
                    ClassDef classDef = ClassPath.loadClassDef(string);
                    if (classDef == null) {
                        throw new ClassNotFoundException(String.format("Could not find interface %s", string));
                    }
                    assert (classDef.isInterface());
                    treeSet.add(classDef);
                    classDef = classDef.getSuperclass();
                    while (!classDef.getClassType().equals("Ljava/lang/Object;")) {
                        assert (classDef.isInterface());
                        treeSet.add(classDef);
                        classDef = classDef.getSuperclass();
                    }
                }
            }
            return treeSet;
        }

        private LinkedHashMap<String, ClassDef> loadInterfaceTable(TempClassInfo tempClassInfo) {
            if (tempClassInfo.interfaces == null) {
                return null;
            }
            LinkedHashMap<String, ClassDef> linkedHashMap = new LinkedHashMap<String, ClassDef>();
            for (String string : tempClassInfo.interfaces) {
                if (linkedHashMap.containsKey(string)) continue;
                ClassDef classDef = ClassPath.loadClassDef(string);
                if (classDef == null) {
                    throw new ClassNotFoundException(String.format("Could not find interface %s", string));
                }
                linkedHashMap.put(string, classDef);
                if (classDef.interfaceTable == null) continue;
                for (ClassDef classDef2 : classDef.interfaceTable.values()) {
                    if (linkedHashMap.containsKey(classDef2.classType)) continue;
                    linkedHashMap.put(classDef2.classType, classDef2);
                }
            }
            return linkedHashMap;
        }

        private String[] loadVtable(TempClassInfo tempClassInfo) {
            LinkedList<String> linkedList = new LinkedList<String>();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n = 0;
            if (this.superclass != null) {
                for (String string : this.superclass.vtable) {
                    linkedList.add(string);
                    hashMap.put(string, n++);
                }
                assert (this.superclass.instanceFields != null);
            }
            if (!this.isInterface) {
                if (tempClassInfo.virtualMethods != null) {
                    for (String string : tempClassInfo.virtualMethods) {
                        if (hashMap.get(string) != null) continue;
                        linkedList.add(string);
                        hashMap.put(string, n++);
                    }
                }
                if (this.interfaceTable != null) {
                    for (ClassDef classDef : this.interfaceTable.values()) {
                        if (classDef.virtualMethods == null) continue;
                        for (String string : classDef.virtualMethods) {
                            if (hashMap.get(string) != null) continue;
                            linkedList.add(string);
                            hashMap.put(string, n++);
                        }
                    }
                }
            }
            String[] stringArray = new String[linkedList.size()];
            for (int i = 0; i < linkedList.size(); ++i) {
                stringArray[i] = (String)linkedList.get(i);
            }
            return stringArray;
        }

        private int getNextFieldOffset() {
            if (this.instanceFields == null || this.instanceFields.size() == 0) {
                return 8;
            }
            int n = this.instanceFields.size() - 1;
            int n2 = this.instanceFields.keyAt(n);
            String string = this.instanceFields.valueAt(n);
            int n3 = string.indexOf(":") + 1;
            switch (string.charAt(n3)) {
                case 'D': 
                case 'J': {
                    return n2 + 8;
                }
            }
            return n2 + 4;
        }

        private SparseArray<String> loadFields(TempClassInfo tempClassInfo) {
            int n;
            int n2;
            int n3;
            int n4;
            String[] stringArray = null;
            byte[] byArray = null;
            if (tempClassInfo.instanceFields != null) {
                stringArray = new String[tempClassInfo.instanceFields.length];
                byArray = new byte[stringArray.length];
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    String[] stringArray2 = tempClassInfo.instanceFields[n4];
                    String string = stringArray2[0];
                    String string2 = stringArray2[1];
                    String string3 = String.format("%s:%s", string, string2);
                    byArray[n4] = this.getFieldType(string2);
                    stringArray[n4] = string3;
                }
            }
            if (stringArray == null) {
                stringArray = new String[]{};
                byArray = new byte[]{};
            }
            n4 = stringArray.length - 1;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (byArray[n3] != 0) {
                    while (n4 > n3) {
                        if (byArray[n4] == 0) {
                            this.swap(byArray, stringArray, n3, n4--);
                            break;
                        }
                        --n4;
                    }
                }
                if (byArray[n3] != 0) break;
            }
            int n5 = 8;
            if (this.superclass != null) {
                n5 = this.superclass.getNextFieldOffset();
            }
            int n6 = n5 % 8 == 0 ? 0 : 1;
            if (n3 < stringArray.length && n3 % 2 != n6) {
                if (byArray[n3] == 1) {
                    for (n4 = stringArray.length - 1; n4 > n3; --n4) {
                        if (byArray[n4] != 2) continue;
                        this.swap(byArray, stringArray, n3++, n4);
                        break;
                    }
                } else {
                    ++n3;
                }
            }
            n4 = stringArray.length - 1;
            while (n3 < stringArray.length) {
                if (byArray[n3] != 1) {
                    while (n4 > n3) {
                        if (byArray[n4] == 1) {
                            this.swap(byArray, stringArray, n3, n4--);
                            break;
                        }
                        --n4;
                    }
                }
                if (byArray[n3] != 1) break;
                ++n3;
            }
            int n7 = 0;
            if (this.superclass != null) {
                n7 = this.superclass.instanceFields.size();
            }
            int n8 = n7 + stringArray.length;
            SparseArray<String> sparseArray = new SparseArray<String>(n8);
            if (this.superclass != null && n7 > 0) {
                for (int i = 0; i < n7; ++i) {
                    sparseArray.append(this.superclass.instanceFields.keyAt(i), this.superclass.instanceFields.valueAt(i));
                }
                n2 = sparseArray.keyAt(n7 - 1);
                String string = this.superclass.instanceFields.valueAt(n7 - 1);
                assert (string.indexOf(58) >= 0);
                assert (string.indexOf(58) < string.length() - 1);
                n = string.charAt(string.indexOf(58) + 1);
                n2 = n == 74 || n == 68 ? (n2 += 8) : (n2 += 4);
            } else {
                n2 = 8;
            }
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                if (byArray[n] == 1 && !bl && !bl) {
                    if (n2 % 8 != 0) {
                        assert (n2 % 8 == 4);
                        n2 += 4;
                    }
                    bl = true;
                }
                sparseArray.append(n2, string);
                if (byArray[n] == 1) {
                    n2 += 8;
                    continue;
                }
                n2 += 4;
            }
            return sparseArray;
        }

        private byte getFieldType(String string) {
            switch (string.charAt(0)) {
                case 'L': 
                case '[': {
                    return 0;
                }
                case 'D': 
                case 'J': {
                    return 1;
                }
            }
            return 2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ClassDef)) {
                return false;
            }
            ClassDef classDef = (ClassDef)object;
            return this.classType.equals(classDef.classType);
        }

        public int hashCode() {
            return this.classType.hashCode();
        }

        @Override
        public int compareTo(ClassDef classDef) {
            return this.classType.compareTo(classDef.classType);
        }
    }

    public static class UnresolvedClassDef
    extends ClassDef {
        protected UnresolvedClassDef(String string) {
            super(string, 2);
            assert (string.charAt(0) == 'L');
        }

        protected ValidationException unresolvedValidationException() {
            return new ValidationException(String.format("class %s cannot be resolved.", this.getClassType()));
        }

        @Override
        public ClassDef getSuperclass() {
            throw this.unresolvedValidationException();
        }

        @Override
        public int getClassDepth() {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean isInterface() {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean extendsClass(ClassDef classDef) {
            if (classDef != theClassPath.javaLangObjectClassDef && classDef != this) {
                throw this.unresolvedValidationException();
            }
            return true;
        }

        @Override
        public boolean implementsInterface(ClassDef classDef) {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean hasVirtualMethod(String string) {
            if (!super.hasVirtualMethod(string)) {
                throw this.unresolvedValidationException();
            }
            return true;
        }
    }

    public static class PrimitiveClassDef
    extends ClassDef {
        protected PrimitiveClassDef(String string) {
            super(string, 1);
            assert (string.charAt(0) != 'L' && string.charAt(0) != '[');
        }
    }

    public static class ArrayClassDef
    extends ClassDef {
        private final ClassDef elementClass;
        private final int arrayDimensions;

        protected ArrayClassDef(String string) {
            super(string, 0);
            assert (string.charAt(0) == '[');
            int n = 0;
            while (string.charAt(n) == '[') {
                ++n;
            }
            String string2 = string.substring(n);
            if (n > 256) {
                throw new ExceptionWithContext("Error while creating array class for element type " + string2 + " with " + n + " dimensions. The maximum number of dimensions is 256");
            }
            try {
                this.elementClass = ClassPath.getClassDef(string.substring(n));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ExceptionWithContext.withContext(classNotFoundException, "Error while creating array class " + string);
            }
            this.arrayDimensions = n;
        }

        public ClassDef getBaseElementClass() {
            return this.elementClass;
        }

        public ClassDef getImmediateElementClass() {
            if (this.arrayDimensions == 1) {
                return this.elementClass;
            }
            return ClassPath.getArrayClassDefByElementClassAndDimension(this.elementClass, this.arrayDimensions - 1);
        }

        public int getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public boolean extendsClass(ClassDef classDef) {
            if (!(classDef instanceof ArrayClassDef)) {
                if (classDef == theClassPath.javaLangObjectClassDef) {
                    return true;
                }
                if (classDef.isInterface) {
                    return this.implementsInterface(classDef);
                }
                return false;
            }
            ArrayClassDef arrayClassDef = (ArrayClassDef)classDef;
            if (this.arrayDimensions == arrayClassDef.arrayDimensions) {
                ClassDef classDef2 = arrayClassDef.getBaseElementClass();
                if (classDef2.isInterface) {
                    return true;
                }
                return classDef2.extendsClass(arrayClassDef.getBaseElementClass());
            }
            if (this.arrayDimensions > arrayClassDef.arrayDimensions) {
                ClassDef classDef3 = arrayClassDef.getBaseElementClass();
                if (classDef3.isInterface) {
                    return true;
                }
                return classDef3 == theClassPath.javaLangObjectClassDef;
            }
            return false;
        }
    }

    private static class ClassNotFoundException
    extends ExceptionWithContext {
        public ClassNotFoundException(String string) {
            super(string);
        }
    }

    public static interface ClassPathErrorHandler {
        public void ClassPathError(String var1, Exception var2);
    }
}

