/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Renderers;

import java.io.IOException;
import org.jf.baksmali.IndentingWriter;

public class LongRenderer {
    public static void writeTo(IndentingWriter indentingWriter, long l) throws IOException {
        if (l < 0L) {
            indentingWriter.write("-0x");
            indentingWriter.printLongAsHex(-l);
            indentingWriter.write(76);
        } else {
            indentingWriter.write("0x");
            indentingWriter.printLongAsHex(l);
            indentingWriter.write(76);
        }
    }

    public static void writeSignedIntOrLongTo(IndentingWriter indentingWriter, long l) throws IOException {
        if (l < 0L) {
            indentingWriter.write("-0x");
            indentingWriter.printLongAsHex(-l);
            if (l < Integer.MIN_VALUE) {
                indentingWriter.write(76);
            }
        } else {
            indentingWriter.write("0x");
            indentingWriter.printLongAsHex(l);
            if (l > Integer.MAX_VALUE) {
                indentingWriter.write(76);
            }
        }
    }
}

