/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends Writer {
    private final Writer writer;
    private final char[] buffer = new char[16];
    private int indentLevel = 0;
    private boolean beginningOfLine;
    private static final String newLine = System.getProperty("line.separator");

    protected IndentingWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(int n) throws IOException {
        if (n == 10) {
            this.writer.write(newLine);
            this.beginningOfLine = true;
        } else {
            if (this.beginningOfLine) {
                for (int i = 0; i < this.indentLevel; ++i) {
                    this.writer.write(32);
                }
            }
            this.beginningOfLine = false;
            this.writer.write(n);
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        for (char c : cArray) {
            this.write(c);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        n2 = n + n2;
        while (n < n2) {
            this.write(cArray[n++]);
        }
    }

    @Override
    public void write(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i));
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        n2 = n + n2;
        while (n < n2) {
            this.write(string.charAt(n++));
        }
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        this.write(((Object)charSequence).toString());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
        this.write(((Object)charSequence.subSequence(n, n2)).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void indent(int n) {
        this.indentLevel += n;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void deindent(int n) {
        this.indentLevel -= n;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void printLongAsHex(long l) throws IOException {
        int n = 0;
        do {
            int n2;
            this.buffer[n++] = (n2 = (int)(l & 0xFL)) < 10 ? (char)(n2 + 48) : (char)(n2 - 10 + 97);
        } while ((l >>>= 4) != 0L);
        while (n > 0) {
            this.write(this.buffer[--n]);
        }
    }

    public void printIntAsDec(int n) throws IOException {
        int n2 = 0;
        boolean bl = n < 0;
        do {
            int n3 = n % 10;
            this.buffer[n2++] = (char)(n3 + 48);
        } while ((n /= 10) != 0);
        if (bl) {
            this.write(45);
        }
        while (n2 > 0) {
            this.write(this.buffer[--n2]);
        }
    }
}

