/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.BlankMethodItem;
import org.jf.baksmali.Adaptors.CatchMethodItem;
import org.jf.baksmali.Adaptors.CommentMethodItem;
import org.jf.baksmali.Adaptors.CommentedOutMethodItem;
import org.jf.baksmali.Adaptors.DebugMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItemFactory;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.PostInstructionRegisterInfoMethodItem;
import org.jf.baksmali.Adaptors.PreInstructionRegisterInfoMethodItem;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseIntArray;

public class MethodDefinition {
    private final ClassDataItem.EncodedMethod encodedMethod;
    private final MethodAnalyzer methodAnalyzer;
    private final LabelCache labelCache = new LabelCache();
    private final SparseIntArray packedSwitchMap;
    private final SparseIntArray sparseSwitchMap;
    private final SparseIntArray instructionMap;

    public MethodDefinition(ClassDataItem.EncodedMethod encodedMethod) {
        try {
            this.encodedMethod = encodedMethod;
            if (encodedMethod.codeItem != null) {
                this.methodAnalyzer = new MethodAnalyzer(encodedMethod, baksmali.deodex);
                List<AnalyzedInstruction> list = this.methodAnalyzer.getInstructions();
                this.packedSwitchMap = new SparseIntArray(1);
                this.sparseSwitchMap = new SparseIntArray(1);
                this.instructionMap = new SparseIntArray(list.size());
                int n = 0;
                for (int i = 0; i < list.size(); ++i) {
                    AnalyzedInstruction analyzedInstruction = list.get(i);
                    if (analyzedInstruction.getInstruction().opcode == Opcode.PACKED_SWITCH) {
                        this.packedSwitchMap.append(n + ((OffsetInstruction)((Object)analyzedInstruction.getInstruction())).getTargetAddressOffset(), n);
                    } else if (analyzedInstruction.getInstruction().opcode == Opcode.SPARSE_SWITCH) {
                        this.sparseSwitchMap.append(n + ((OffsetInstruction)((Object)analyzedInstruction.getInstruction())).getTargetAddressOffset(), n);
                    }
                    this.instructionMap.append(n, i);
                    n += analyzedInstruction.getInstruction().getSize(n);
                }
            } else {
                this.packedSwitchMap = null;
                this.sparseSwitchMap = null;
                this.instructionMap = null;
                this.methodAnalyzer = null;
            }
        }
        catch (Exception exception) {
            throw ExceptionWithContext.withContext(exception, String.format("Error while processing method %s", encodedMethod.method.getMethodString()));
        }
    }

    public void writeTo(IndentingWriter indentingWriter, AnnotationSetItem annotationSetItem, AnnotationSetRefList annotationSetRefList) throws IOException {
        CodeItem codeItem = this.encodedMethod.codeItem;
        indentingWriter.write(".method ");
        MethodDefinition.writeAccessFlags(indentingWriter, this.encodedMethod);
        indentingWriter.write(this.encodedMethod.method.getMethodName().getStringValue());
        indentingWriter.write(this.encodedMethod.method.getPrototype().getPrototypeString());
        indentingWriter.write(10);
        indentingWriter.indent(4);
        if (codeItem != null) {
            if (baksmali.useLocalsDirective) {
                indentingWriter.write(".locals ");
            } else {
                indentingWriter.write(".registers ");
            }
            indentingWriter.printIntAsDec(MethodDefinition.getRegisterCount(this.encodedMethod));
            indentingWriter.write(10);
            MethodDefinition.writeParameters(indentingWriter, codeItem, annotationSetRefList);
            if (annotationSetItem != null) {
                AnnotationFormatter.writeTo(indentingWriter, annotationSetItem);
            }
            indentingWriter.write(10);
            for (MethodItem methodItem : this.getMethodItems()) {
                if (!methodItem.writeTo(indentingWriter)) continue;
                indentingWriter.write(10);
            }
        } else if (annotationSetItem != null) {
            AnnotationFormatter.writeTo(indentingWriter, annotationSetItem);
        }
        indentingWriter.deindent(4);
        indentingWriter.write(".end method\n");
    }

    private static int getRegisterCount(ClassDataItem.EncodedMethod encodedMethod) {
        int n = encodedMethod.codeItem.getRegisterCount();
        if (baksmali.useLocalsDirective) {
            int n2 = encodedMethod.method.getPrototype().getParameterRegisterCount();
            if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
                ++n2;
            }
            return n - n2;
        }
        return n;
    }

    private static void writeAccessFlags(IndentingWriter indentingWriter, ClassDataItem.EncodedMethod encodedMethod) throws IOException {
        for (AccessFlags accessFlags : AccessFlags.getAccessFlagsForMethod(encodedMethod.accessFlags)) {
            indentingWriter.write(accessFlags.toString());
            indentingWriter.write(32);
        }
    }

    private static void writeParameters(IndentingWriter indentingWriter, CodeItem codeItem, AnnotationSetRefList annotationSetRefList) throws IOException {
        AnnotationSetItem[] annotationSetItemArray;
        DebugInfoItem debugInfoItem = null;
        if (baksmali.outputDebugInfo && codeItem != null) {
            debugInfoItem = codeItem.getDebugInfo();
        }
        int n = 0;
        StringIdItem[] stringIdItemArray = null;
        if (annotationSetRefList != null) {
            annotationSetItemArray = annotationSetRefList.getAnnotationSets();
            n = annotationSetItemArray.length;
        } else {
            annotationSetItemArray = new AnnotationSetItem[]{};
        }
        if (debugInfoItem != null) {
            stringIdItemArray = debugInfoItem.getParameterNames();
        }
        if (stringIdItemArray == null) {
            stringIdItemArray = new StringIdItem[]{};
        }
        if (n < stringIdItemArray.length) {
            n = stringIdItemArray.length;
        }
        for (int i = 0; i < n; ++i) {
            AnnotationSetItem annotationSetItem = null;
            if (i < annotationSetItemArray.length) {
                annotationSetItem = annotationSetItemArray[i];
            }
            StringIdItem stringIdItem = null;
            if (i < stringIdItemArray.length) {
                stringIdItem = stringIdItemArray[i];
            }
            indentingWriter.write(".parameter");
            if (stringIdItem != null) {
                indentingWriter.write(" \"");
                indentingWriter.write(stringIdItem.getStringValue());
                indentingWriter.write(34);
            }
            indentingWriter.write(10);
            if (annotationSetItem == null) continue;
            indentingWriter.indent(4);
            AnnotationFormatter.writeTo(indentingWriter, annotationSetItem);
            indentingWriter.deindent(4);
            indentingWriter.write(".end parameter\n");
        }
    }

    public LabelCache getLabelCache() {
        return this.labelCache;
    }

    public ValidationException getValidationException() {
        if (this.methodAnalyzer == null) {
            return null;
        }
        return this.methodAnalyzer.getValidationException();
    }

    public int getPackedSwitchBaseAddress(int n) {
        int n2 = this.packedSwitchMap.get(n, -1);
        if (n2 == -1) {
            throw new RuntimeException("Could not find the packed switch statement corresponding to the packed switch data at address " + n);
        }
        return n2;
    }

    public int getSparseSwitchBaseAddress(int n) {
        int n2 = this.sparseSwitchMap.get(n, -1);
        if (n2 == -1) {
            throw new RuntimeException("Could not find the sparse switch statement corresponding to the sparse switch data at address " + n);
        }
        return n2;
    }

    private boolean isInstructionPaddingNop(List<AnalyzedInstruction> list, AnalyzedInstruction analyzedInstruction) {
        if (analyzedInstruction.getInstruction().opcode != Opcode.NOP || analyzedInstruction.getInstruction().getFormat().variableSizeFormat) {
            return false;
        }
        if (analyzedInstruction.getInstructionIndex() == list.size() - 1) {
            return false;
        }
        AnalyzedInstruction analyzedInstruction2 = list.get(analyzedInstruction.getInstructionIndex() + 1);
        return analyzedInstruction2.getInstruction().getFormat().variableSizeFormat;
    }

    private List<MethodItem> getMethodItems() {
        int n;
        Object object;
        ArrayList<MethodItem> arrayList = new ArrayList<MethodItem>();
        if (this.encodedMethod.codeItem == null) {
            return arrayList;
        }
        if (baksmali.registerInfo != 0 || baksmali.deodex || baksmali.verify) {
            this.methodAnalyzer.analyze();
            object = this.methodAnalyzer.getValidationException();
            if (object != null) {
                arrayList.add(new CommentMethodItem(String.format("ValidationException: %s", ((Throwable)object).getMessage()), ((ValidationException)object).getCodeAddress(), -2.147483648E9));
            } else if (baksmali.verify) {
                this.methodAnalyzer.verify();
                object = this.methodAnalyzer.getValidationException();
                if (object != null) {
                    arrayList.add(new CommentMethodItem(String.format("ValidationException: %s", ((Throwable)object).getMessage()), ((ValidationException)object).getCodeAddress(), -2.147483648E9));
                }
            }
        }
        object = this.methodAnalyzer.getInstructions();
        AnalyzedInstruction analyzedInstruction = null;
        for (n = object.size() - 1; n >= 0; --n) {
            AnalyzedInstruction analyzedInstruction2 = (AnalyzedInstruction)object.get(n);
            if (analyzedInstruction2.isDead()) continue;
            analyzedInstruction = analyzedInstruction2;
            break;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < object.size(); ++i) {
            AnalyzedInstruction comparable = (AnalyzedInstruction)object.get(i);
            InstructionMethodItem instructionMethodItem = InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, n2, comparable.isDead(), comparable.getInstruction(), comparable == analyzedInstruction);
            if (comparable.isDead() && !comparable.getInstruction().getFormat().variableSizeFormat) {
                arrayList.add(new CommentedOutMethodItem(instructionMethodItem));
                n = 0;
            } else if (comparable.getPredecessorCount() == 0 && !comparable.getInstruction().getFormat().variableSizeFormat && !this.isInstructionPaddingNop((List<AnalyzedInstruction>)object, comparable)) {
                if (n == 0) {
                    arrayList.add(new CommentMethodItem("Unreachable code", n2, Double.MIN_VALUE));
                }
                arrayList.add(new CommentedOutMethodItem(instructionMethodItem));
                n = 1;
            } else {
                arrayList.add(instructionMethodItem);
                n = 0;
            }
            if (comparable.getInstruction().getFormat() == Format.UnresolvedNullReference) {
                arrayList.add(new CommentedOutMethodItem(InstructionMethodItemFactory.makeInstructionFormatMethodItem(this, this.encodedMethod.codeItem, n2, comparable.isDead(), comparable.getOriginalInstruction(), false)));
            }
            if (i != object.size() - 1) {
                arrayList.add(new BlankMethodItem(n2));
            }
            if (baksmali.addCodeOffsets) {
                arrayList.add(new MethodItem(n2){

                    @Override
                    public double getSortOrder() {
                        return -1000.0;
                    }

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        indentingWriter.write("#@");
                        indentingWriter.printLongAsHex(this.codeAddress & 0xFFFFFFFF);
                        return true;
                    }
                });
            }
            if (baksmali.registerInfo != 0 && !comparable.getInstruction().getFormat().variableSizeFormat) {
                arrayList.add(new PreInstructionRegisterInfoMethodItem(comparable, this.methodAnalyzer, n2));
                arrayList.add(new PostInstructionRegisterInfoMethodItem(comparable, this.methodAnalyzer, n2));
            }
            n2 += comparable.getInstruction().getSize(n2);
        }
        this.addTries(arrayList);
        this.addDebugInfo(arrayList);
        if (baksmali.useSequentialLabels) {
            this.setLabelSequentialNumbers();
        }
        for (LabelMethodItem labelMethodItem : this.labelCache.getLabels()) {
            if (labelMethodItem.isCommentedOut()) {
                arrayList.add(new CommentedOutMethodItem(labelMethodItem));
                continue;
            }
            arrayList.add(labelMethodItem);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void addTries(List<MethodItem> list) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getTries() == null) {
            return;
        }
        Instruction[] instructionArray = this.encodedMethod.codeItem.getInstructions();
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            int n;
            int n2;
            Instruction instruction;
            int n3 = tryItem.getStartCodeAddress();
            int n4 = tryItem.getStartCodeAddress() + tryItem.getTryLength();
            int n5 = this.instructionMap.get(n4, -1);
            if (n5 == -1) {
                instruction = instructionArray[instructionArray.length - 1];
                n2 = this.instructionMap.keyAt(this.instructionMap.size() - 1);
                if (n4 != n2 + instruction.getSize(n2)) {
                    throw new RuntimeException("Invalid code offset " + n4 + " for the try block end address");
                }
            } else {
                if (n5 == 0) {
                    throw new RuntimeException("Unexpected instruction index");
                }
                instruction = instructionArray[n5 - 1];
                if (instruction.getFormat().variableSizeFormat) {
                    throw new RuntimeException("This try block unexpectedly ends on a switch/array data block.");
                }
                n2 = n4 - instruction.getSize(0);
            }
            if ((n = tryItem.encodedCatchHandler.getCatchAllHandlerAddress()) != -1) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, n2, null, n3, n4, n);
                list.add(catchMethodItem);
            }
            for (CodeItem.EncodedTypeAddrPair encodedTypeAddrPair : tryItem.encodedCatchHandler.handlers) {
                CatchMethodItem catchMethodItem = new CatchMethodItem(this.labelCache, n2, encodedTypeAddrPair.exceptionType, n3, n4, encodedTypeAddrPair.getHandlerAddress());
                list.add(catchMethodItem);
            }
        }
    }

    private void addDebugInfo(final List<MethodItem> list) {
        if (this.encodedMethod.codeItem == null || this.encodedMethod.codeItem.getDebugInfo() == null) {
            return;
        }
        final CodeItem codeItem = this.encodedMethod.codeItem;
        DebugInfoItem debugInfoItem = codeItem.getDebugInfo();
        DebugInstructionIterator.DecodeInstructions(debugInfoItem, codeItem.getRegisterCount(), new DebugInstructionIterator.ProcessDecodedDebugInstructionDelegate(){

            @Override
            public void ProcessStartLocal(int n, int n2, final int n3, final StringIdItem stringIdItem, final TypeIdItem typeIdItem) {
                list.add(new DebugMethodItem(n, -1.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        1.writeStartLocal(indentingWriter, codeItem, n3, stringIdItem, typeIdItem, null);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, final int n3, final StringIdItem stringIdItem, final TypeIdItem typeIdItem, final StringIdItem stringIdItem2) {
                list.add(new DebugMethodItem(n, -1.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        2.writeStartLocal(indentingWriter, codeItem, n3, stringIdItem, typeIdItem, stringIdItem2);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessEndLocal(int n, int n2, final int n3, final StringIdItem stringIdItem, final TypeIdItem typeIdItem, final StringIdItem stringIdItem2) {
                list.add(new DebugMethodItem(n, -1.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        3.writeEndLocal(indentingWriter, codeItem, n3, stringIdItem, typeIdItem, stringIdItem2);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessRestartLocal(int n, int n2, final int n3, final StringIdItem stringIdItem, final TypeIdItem typeIdItem, final StringIdItem stringIdItem2) {
                list.add(new DebugMethodItem(n, -1.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        4.writeRestartLocal(indentingWriter, codeItem, n3, stringIdItem, typeIdItem, stringIdItem2);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessSetPrologueEnd(int n) {
                list.add(new DebugMethodItem(n, -4.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        5.writeEndPrologue(indentingWriter);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessSetEpilogueBegin(int n) {
                list.add(new DebugMethodItem(n, -4.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        6.writeBeginEpilogue(indentingWriter);
                        return true;
                    }
                });
            }

            @Override
            public void ProcessSetFile(int n, int n2, final StringIdItem stringIdItem) {
                list.add(new DebugMethodItem(n, -3.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        7.writeSetFile(indentingWriter, stringIdItem.getStringValue());
                        return true;
                    }
                });
            }

            @Override
            public void ProcessLineEmit(int n, final int n2) {
                list.add(new DebugMethodItem(n, -2.0){

                    @Override
                    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
                        8.writeLine(indentingWriter, n2);
                        return true;
                    }
                });
            }
        });
    }

    private void setLabelSequentialNumbers() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<LabelMethodItem> arrayList = new ArrayList<LabelMethodItem>(this.labelCache.getLabels());
        Collections.sort(arrayList);
        for (LabelMethodItem labelMethodItem : arrayList) {
            Integer n = (Integer)hashMap.get(labelMethodItem.getLabelPrefix());
            if (n == null) {
                n = 0;
            }
            labelMethodItem.setLabelSequence(n);
            hashMap.put(labelMethodItem.getLabelPrefix(), n + 1);
        }
    }

    public static class LabelCache {
        protected HashMap<LabelMethodItem, LabelMethodItem> labels = new HashMap();

        public LabelMethodItem internLabel(LabelMethodItem labelMethodItem) {
            LabelMethodItem labelMethodItem2 = this.labels.get(labelMethodItem);
            if (labelMethodItem2 != null) {
                if (!labelMethodItem.isCommentedOut()) {
                    labelMethodItem2.setUncommented();
                }
                return labelMethodItem2;
            }
            this.labels.put(labelMethodItem, labelMethodItem);
            return labelMethodItem;
        }

        public Collection<LabelMethodItem> getLabels() {
            return this.labels.values();
        }
    }
}

