/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.Iterator;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.Renderers.ByteRenderer;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.CodeItem;

public class ArrayDataMethodItem
extends InstructionMethodItem<ArrayDataPseudoInstruction> {
    private final boolean dead;

    public ArrayDataMethodItem(CodeItem codeItem, int n, boolean bl, ArrayDataPseudoInstruction arrayDataPseudoInstruction) {
        super(codeItem, n, arrayDataPseudoInstruction);
        this.dead = bl;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        if (this.dead) {
            indentingWriter.write("#.array-data 0x");
            indentingWriter.printLongAsHex(((ArrayDataPseudoInstruction)this.instruction).getElementWidth());
            indentingWriter.write(10);
            Iterator<ArrayDataPseudoInstruction.ArrayElement> iterator = ((ArrayDataPseudoInstruction)this.instruction).getElements();
            while (iterator.hasNext()) {
                ArrayDataPseudoInstruction.ArrayElement arrayElement = iterator.next();
                indentingWriter.write("#   ");
                for (int i = 0; i < arrayElement.elementWidth; ++i) {
                    if (i != 0) {
                        indentingWriter.write(32);
                    }
                    ByteRenderer.writeUnsignedTo(indentingWriter, arrayElement.buffer[arrayElement.bufferIndex + i]);
                }
                indentingWriter.write(10);
            }
            indentingWriter.write("#.end array-data");
        } else {
            indentingWriter.write(".array-data 0x");
            indentingWriter.printLongAsHex(((ArrayDataPseudoInstruction)this.instruction).getElementWidth());
            indentingWriter.write(10);
            indentingWriter.indent(4);
            Iterator<ArrayDataPseudoInstruction.ArrayElement> iterator = ((ArrayDataPseudoInstruction)this.instruction).getElements();
            while (iterator.hasNext()) {
                ArrayDataPseudoInstruction.ArrayElement arrayElement = iterator.next();
                for (int i = 0; i < arrayElement.elementWidth; ++i) {
                    if (i != 0) {
                        indentingWriter.write(32);
                    }
                    ByteRenderer.writeUnsignedTo(indentingWriter, arrayElement.buffer[arrayElement.bufferIndex + i]);
                }
                indentingWriter.write(10);
            }
            indentingWriter.deindent(4);
            indentingWriter.write(".end array-data");
        }
        return true;
    }
}

