/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public abstract class Parser
implements CommandLineParser {
    protected CommandLine cmd;
    private Options options;
    private List requiredOptions;

    protected void setOptions(Options options) {
        this.options = options;
        this.requiredOptions = new ArrayList(options.getRequiredOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    protected List getRequiredOptions() {
        return this.requiredOptions;
    }

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3);

    @Override
    public CommandLine parse(Options options, String[] stringArray) throws ParseException {
        return this.parse(options, stringArray, null, false);
    }

    public CommandLine parse(Options options, String[] stringArray, Properties properties, boolean bl) throws ParseException {
        Object object2;
        for (Object object2 : options.helpOptions()) {
            ((Option)object2).clearValues();
        }
        this.setOptions(options);
        this.cmd = new CommandLine();
        boolean bl2 = false;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        object2 = Arrays.asList(this.flatten(this.getOptions(), stringArray, bl));
        ListIterator listIterator = object2.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if ("--".equals(string)) {
                bl2 = true;
            } else if ("-".equals(string)) {
                if (bl) {
                    bl2 = true;
                } else {
                    this.cmd.addArg(string);
                }
            } else if (string.startsWith("-")) {
                if (bl && !this.getOptions().hasOption(string)) {
                    bl2 = true;
                    this.cmd.addArg(string);
                } else {
                    this.processOption(string, listIterator);
                }
            } else {
                this.cmd.addArg(string);
                if (bl) {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            while (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                if ("--".equals(string2)) continue;
                this.cmd.addArg(string2);
            }
        }
        this.processProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    protected void processProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if (this.cmd.hasOption(string)) continue;
            Option option = this.getOptions().getOption(string);
            String string2 = properties.getProperty(string);
            if (option.hasArg()) {
                if (option.getValues() == null || option.getValues().length == 0) {
                    try {
                        option.addValueForProcessing(string2);
                    }
                    catch (RuntimeException runtimeException) {}
                }
            } else if (!"yes".equalsIgnoreCase(string2) && !"true".equalsIgnoreCase(string2) && !"1".equalsIgnoreCase(string2)) break;
            this.cmd.addOption(option);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.getRequiredOptions().isEmpty()) {
            throw new MissingOptionException(this.getRequiredOptions());
        }
    }

    public void processArgs(Option option, ListIterator listIterator) throws ParseException {
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (this.getOptions().hasOption(string) && string.startsWith("-")) {
                listIterator.previous();
                break;
            }
            try {
                option.addValueForProcessing(Util.stripLeadingAndTrailingQuotes(string));
            }
            catch (RuntimeException runtimeException) {
                listIterator.previous();
                break;
            }
        }
        if (option.getValues() == null && !option.hasOptionalArg()) {
            throw new MissingArgumentException(option);
        }
    }

    protected void processOption(String string, ListIterator listIterator) throws ParseException {
        boolean bl = this.getOptions().hasOption(string);
        if (!bl) {
            throw new UnrecognizedOptionException("Unrecognized option: " + string, string);
        }
        Option option = (Option)this.getOptions().getOption(string).clone();
        if (option.isRequired()) {
            this.getRequiredOptions().remove(option.getKey());
        }
        if (this.getOptions().getOptionGroup(option) != null) {
            OptionGroup optionGroup = this.getOptions().getOptionGroup(option);
            if (optionGroup.isRequired()) {
                this.getRequiredOptions().remove(optionGroup);
            }
            optionGroup.setSelected(option);
        }
        if (option.hasArg()) {
            this.processArgs(option, listIterator);
        }
        this.cmd.addOption(option);
    }
}

