/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.OptionValidator;

public class Option
implements Serializable,
Cloneable {
    private String opt;
    private String longOpt;
    private String argName = "arg";
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int numberOfArgs = -1;
    private Object type;
    private List values = new ArrayList();
    private char valuesep;

    public Option(String string, String string2) throws IllegalArgumentException {
        this(string, null, false, string2);
    }

    public Option(String string, String string2, boolean bl, String string3) throws IllegalArgumentException {
        OptionValidator.validateOption(string);
        this.opt = string;
        this.longOpt = string2;
        if (bl) {
            this.numberOfArgs = 1;
        }
        this.description = string3;
    }

    String getKey() {
        if (this.opt == null) {
            return this.longOpt;
        }
        return this.opt;
    }

    public String getOpt() {
        return this.opt;
    }

    public void setType(Object object) {
        this.type = object;
    }

    public String getLongOpt() {
        return this.longOpt;
    }

    public void setLongOpt(String string) {
        this.longOpt = string;
    }

    public void setOptionalArg(boolean bl) {
        this.optionalArg = bl;
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasLongOpt() {
        return this.longOpt != null;
    }

    public boolean hasArg() {
        return this.numberOfArgs > 0 || this.numberOfArgs == -2;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setArgName(String string) {
        this.argName = string;
    }

    public String getArgName() {
        return this.argName;
    }

    public boolean hasArgName() {
        return this.argName != null && this.argName.length() > 0;
    }

    public boolean hasArgs() {
        return this.numberOfArgs > 1 || this.numberOfArgs == -2;
    }

    public void setArgs(int n) {
        this.numberOfArgs = n;
    }

    public void setValueSeparator(char c) {
        this.valuesep = c;
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public boolean hasValueSeparator() {
        return this.valuesep > '\u0000';
    }

    void addValueForProcessing(String string) {
        switch (this.numberOfArgs) {
            case -1: {
                throw new RuntimeException("NO_ARGS_ALLOWED");
            }
        }
        this.processValue(string);
    }

    private void processValue(String string) {
        if (this.hasValueSeparator()) {
            char c = this.getValueSeparator();
            int n = string.indexOf(c);
            while (n != -1 && this.values.size() != this.numberOfArgs - 1) {
                this.add(string.substring(0, n));
                string = string.substring(n + 1);
                n = string.indexOf(c);
            }
        }
        this.add(string);
    }

    private void add(String string) {
        if (this.numberOfArgs > 0 && this.values.size() > this.numberOfArgs - 1) {
            throw new RuntimeException("Cannot add value, list full.");
        }
        this.values.add(string);
    }

    public String getValue() {
        return this.hasNoValues() ? null : (String)this.values.get(0);
    }

    public String[] getValues() {
        return this.hasNoValues() ? null : this.values.toArray(new String[this.values.size()]);
    }

    public List getValuesList() {
        return this.values;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[ option: ");
        stringBuffer.append(this.opt);
        if (this.longOpt != null) {
            stringBuffer.append(" ").append(this.longOpt);
        }
        stringBuffer.append(" ");
        if (this.hasArgs()) {
            stringBuffer.append("[ARG...]");
        } else if (this.hasArg()) {
            stringBuffer.append(" [ARG]");
        }
        stringBuffer.append(" :: ").append(this.description);
        if (this.type != null) {
            stringBuffer.append(" :: ").append(this.type);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Option option = (Option)object;
        if (this.opt != null ? !this.opt.equals(option.opt) : option.opt != null) {
            return false;
        }
        return !(this.longOpt != null ? !this.longOpt.equals(option.longOpt) : option.longOpt != null);
    }

    public int hashCode() {
        int n = this.opt != null ? this.opt.hashCode() : 0;
        n = 31 * n + (this.longOpt != null ? this.longOpt.hashCode() : 0);
        return n;
    }

    public Object clone() {
        try {
            Option option = (Option)super.clone();
            option.values = new ArrayList(this.values);
            return option;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("A CloneNotSupportedException was thrown: " + cloneNotSupportedException.getMessage());
        }
    }

    void clearValues() {
        this.values.clear();
    }
}

