/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class HelpFormatter {
    public int defaultWidth = 74;
    public int defaultLeftPad = 1;
    public int defaultDescPad = 3;
    public String defaultSyntaxPrefix = "usage: ";
    public String defaultNewLine = System.getProperty("line.separator");
    public String defaultOptPrefix = "-";
    public String defaultLongOptPrefix = "--";
    public String defaultArgName = "arg";
    protected Comparator optionComparator = new OptionComparator();

    public void setWidth(int n) {
        this.defaultWidth = n;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public Comparator getOptionComparator() {
        return this.optionComparator;
    }

    public void printHelp(String string, String string2, Options options, String string3) {
        this.printHelp(string, string2, options, string3, false);
    }

    public void printHelp(String string, String string2, Options options, String string3, boolean bl) {
        this.printHelp(this.defaultWidth, string, string2, options, string3, bl);
    }

    public void printHelp(int n, String string, String string2, Options options, String string3, boolean bl) {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.printHelp(printWriter, n, string, string2, options, this.defaultLeftPad, this.defaultDescPad, string3, bl);
        printWriter.flush();
    }

    public void printHelp(PrintWriter printWriter, int n, String string, String string2, Options options, int n2, int n3, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (bl) {
            this.printUsage(printWriter, n, string, options);
        } else {
            this.printUsage(printWriter, n, string);
        }
        if (string2 != null && string2.trim().length() > 0) {
            this.printWrapped(printWriter, n, string2);
        }
        this.printOptions(printWriter, n, options, n2, n3);
        if (string3 != null && string3.trim().length() > 0) {
            this.printWrapped(printWriter, n, string3);
        }
    }

    public void printUsage(PrintWriter printWriter, int n, String string, Options options) {
        StringBuffer stringBuffer = new StringBuffer(this.defaultSyntaxPrefix).append(string).append(" ");
        ArrayList<OptionGroup> arrayList = new ArrayList<OptionGroup>();
        ArrayList arrayList2 = new ArrayList(options.getOptions());
        Collections.sort(arrayList2, this.getOptionComparator());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            OptionGroup optionGroup = options.getOptionGroup(option);
            if (optionGroup != null) {
                if (!arrayList.contains(optionGroup)) {
                    arrayList.add(optionGroup);
                    this.appendOptionGroup(stringBuffer, optionGroup);
                }
            } else {
                HelpFormatter.appendOption(stringBuffer, option, option.isRequired());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        this.printWrapped(printWriter, n, stringBuffer.toString().indexOf(32) + 1, stringBuffer.toString());
    }

    private void appendOptionGroup(StringBuffer stringBuffer, OptionGroup optionGroup) {
        if (!optionGroup.isRequired()) {
            stringBuffer.append("[");
        }
        ArrayList arrayList = new ArrayList(optionGroup.getOptions());
        Collections.sort(arrayList, this.getOptionComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            HelpFormatter.appendOption(stringBuffer, (Option)iterator.next(), true);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" | ");
        }
        if (!optionGroup.isRequired()) {
            stringBuffer.append("]");
        }
    }

    private static void appendOption(StringBuffer stringBuffer, Option option, boolean bl) {
        if (!bl) {
            stringBuffer.append("[");
        }
        if (option.getOpt() != null) {
            stringBuffer.append("-").append(option.getOpt());
        } else {
            stringBuffer.append("--").append(option.getLongOpt());
        }
        if (option.hasArg() && option.hasArgName()) {
            stringBuffer.append(" <").append(option.getArgName()).append(">");
        }
        if (!bl) {
            stringBuffer.append("]");
        }
    }

    public void printUsage(PrintWriter printWriter, int n, String string) {
        int n2 = string.indexOf(32) + 1;
        this.printWrapped(printWriter, n, this.defaultSyntaxPrefix.length() + n2, this.defaultSyntaxPrefix + string);
    }

    public void printOptions(PrintWriter printWriter, int n, Options options, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        this.renderOptions(stringBuffer, n, options, n2, n3);
        printWriter.println(stringBuffer.toString());
    }

    public void printWrapped(PrintWriter printWriter, int n, String string) {
        this.printWrapped(printWriter, n, 0, string);
    }

    public void printWrapped(PrintWriter printWriter, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        this.renderWrappedText(stringBuffer, n, n2, string);
        printWriter.println(stringBuffer.toString());
    }

    protected StringBuffer renderOptions(StringBuffer stringBuffer, int n, Options options, int n2, int n3) {
        StringBuffer stringBuffer2;
        Object object2;
        String string = this.createPadding(n2);
        String string2 = this.createPadding(n3);
        int n4 = 0;
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        List list = options.helpOptions();
        Collections.sort(list, this.getOptionComparator());
        for (Object object2 : list) {
            stringBuffer2 = new StringBuffer(8);
            if (((Option)object2).getOpt() == null) {
                stringBuffer2.append(string).append("   " + this.defaultLongOptPrefix).append(((Option)object2).getLongOpt());
            } else {
                stringBuffer2.append(string).append(this.defaultOptPrefix).append(((Option)object2).getOpt());
                if (((Option)object2).hasLongOpt()) {
                    stringBuffer2.append(',').append(this.defaultLongOptPrefix).append(((Option)object2).getLongOpt());
                }
            }
            if (((Option)object2).hasArg()) {
                if (((Option)object2).hasArgName()) {
                    stringBuffer2.append(" <").append(((Option)object2).getArgName()).append(">");
                } else {
                    stringBuffer2.append(' ');
                }
            }
            arrayList.add(stringBuffer2);
            n4 = stringBuffer2.length() > n4 ? stringBuffer2.length() : n4;
        }
        int n5 = 0;
        object2 = list.iterator();
        while (object2.hasNext()) {
            Option option = (Option)object2.next();
            if ((stringBuffer2 = new StringBuffer(arrayList.get(n5++).toString())).length() < n4) {
                stringBuffer2.append(this.createPadding(n4 - stringBuffer2.length()));
            }
            stringBuffer2.append(string2);
            int n6 = n4 + n3;
            if (option.getDescription() != null) {
                stringBuffer2.append(option.getDescription());
            }
            this.renderWrappedText(stringBuffer, n, n6, stringBuffer2.toString());
            if (!object2.hasNext()) continue;
            stringBuffer.append(this.defaultNewLine);
        }
        return stringBuffer;
    }

    protected StringBuffer renderWrappedText(StringBuffer stringBuffer, int n, int n2, String string) {
        int n3 = this.findWrapPos(string, n, 0);
        if (n3 == -1) {
            stringBuffer.append(this.rtrim(string));
            return stringBuffer;
        }
        stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.defaultNewLine);
        if (n2 >= n) {
            n2 = 1;
        }
        String string2 = this.createPadding(n2);
        while (true) {
            if ((n3 = this.findWrapPos(string = string2 + string.substring(n3).trim(), n, 0)) == -1) {
                stringBuffer.append(string);
                return stringBuffer;
            }
            if (string.length() > n && n3 == n2 - 1) {
                n3 = n;
            }
            stringBuffer.append(this.rtrim(string.substring(0, n3))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String string, int n, int n2) {
        char c;
        int n3 = -1;
        n3 = string.indexOf(10, n2);
        if (n3 != -1 && n3 <= n || (n3 = string.indexOf(9, n2)) != -1 && n3 <= n) {
            return n3 + 1;
        }
        if (n2 + n >= string.length()) {
            return -1;
        }
        for (n3 = n2 + n; n3 >= n2 && (c = string.charAt(n3)) != ' ' && c != '\n' && c != '\r'; --n3) {
        }
        if (n3 > n2) {
            return n3;
        }
        for (n3 = n2 + n; n3 <= string.length() && (c = string.charAt(n3)) != ' ' && c != '\n' && c != '\r'; ++n3) {
        }
        return n3 == string.length() ? -1 : n3;
    }

    protected String createPadding(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    protected String rtrim(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return string;
        }
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return string.substring(0, n);
    }

    private static class OptionComparator
    implements Comparator {
        private OptionComparator() {
        }

        public int compare(Object object, Object object2) {
            Option option = (Option)object;
            Option option2 = (Option)object2;
            return option.getKey().compareToIgnoreCase(option2.getKey());
        }
    }
}

