/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private List args = new LinkedList();
    private List options = new ArrayList();

    CommandLine() {
    }

    public boolean hasOption(String string) {
        return this.options.contains(this.resolveOption(string));
    }

    public String getOptionValue(String string) {
        String[] stringArray = this.getOptionValues(string);
        return stringArray == null ? null : stringArray[0];
    }

    public String[] getOptionValues(String string) {
        ArrayList arrayList = new ArrayList();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            arrayList.addAll(option.getValuesList());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private Option resolveOption(String string) {
        string = Util.stripLeadingHyphens(string);
        for (Option option : this.options) {
            if (string.equals(option.getOpt())) {
                return option;
            }
            if (!string.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char c) {
        return this.getOptionValues(String.valueOf(c));
    }

    public String getOptionValue(String string, String string2) {
        String string3 = this.getOptionValue(string);
        return string3 != null ? string3 : string2;
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        return stringArray;
    }

    void addArg(String string) {
        this.args.add(string);
    }

    void addOption(Option option) {
        this.options.add(option);
    }

    public Option[] getOptions() {
        List list = this.options;
        Option[] optionArray = new Option[list.size()];
        return list.toArray(optionArray);
    }
}

