/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;

    public T remove() {
        T t = this.get(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return t;
    }

    public void add(T t) {
        this.data.add(t);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public T get(int n) {
        if (this.p + n >= this.data.size()) {
            throw new NoSuchElementException("queue index " + (this.p + n) + " > size " + this.data.size());
        }
        return this.data.get(this.p + n);
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.get(i));
            if (i + 1 >= n) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

