/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime;

public class BitSet
implements Cloneable {
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    public BitSet or(BitSet bitSet) {
        if (bitSet == null) {
            return this;
        }
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = n - 1; i >= 0; --i) {
            int n2 = i;
            this.bits[n2] = this.bits[n2] | bitSet.bits[i];
        }
    }

    private void setSize(int n) {
        long[] lArray = new long[n];
        int n2 = Math.min(n, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n2);
        this.bits = lArray;
    }

    private static final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public boolean equals(Object object) {
        block5: {
            int n;
            int n2;
            BitSet bitSet;
            block4: {
                if (object == null || !(object instanceof BitSet)) {
                    return false;
                }
                bitSet = (BitSet)object;
                n2 = Math.min(this.bits.length, bitSet.bits.length);
                for (n = 0; n < n2; ++n) {
                    if (this.bits[n] == bitSet.bits[n]) continue;
                    return false;
                }
                if (this.bits.length <= n2) break block4;
                for (n = n2 + 1; n < this.bits.length; ++n) {
                    if (this.bits[n] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (bitSet.bits.length <= n2) break block5;
            for (n = n2 + 1; n < bitSet.bits.length; ++n) {
                if (bitSet.bits[n] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean member(int n) {
        if (n < 0) {
            return false;
        }
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
    }

    public void remove(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 < this.bits.length) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (BitSet.bitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private static final int wordNumber(int n) {
        return n >> 6;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ",";
        boolean bl = false;
        stringBuffer.append('{');
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (i > 0 && bl) {
                stringBuffer.append(string);
            }
            if (stringArray != null) {
                stringBuffer.append(stringArray[i]);
            } else {
                stringBuffer.append(i);
            }
            bl = true;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

