/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class OS {
    public static void rmdir(File file) throws BrutException {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                OS.rmdir(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    public static void cpdir(File file, File file2) throws BrutException {
        file2.mkdirs();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file2.getPath() + File.separatorChar + file3.getName());
            if (file3.isDirectory()) {
                OS.cpdir(file3, file4);
                continue;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file3);
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                IOUtils.copy(fileInputStream, fileOutputStream);
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
                continue;
            }
            catch (IOException iOException) {
                throw new BrutException("Could not copy file: " + file3, iOException);
            }
        }
    }

    public static void exec(String[] stringArray) throws BrutException {
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(stringArray);
            new StreamForwarder(process.getInputStream(), System.err).start();
            new StreamForwarder(process.getErrorStream(), System.err).start();
            if (process.waitFor() != 0) {
                throw new BrutException("could not exec command: " + Arrays.toString(stringArray));
            }
        }
        catch (IOException iOException) {
            throw new BrutException("could not exec command: " + Arrays.toString(stringArray), iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new BrutException("could not exec command: " + Arrays.toString(stringArray), interruptedException);
        }
    }

    static class StreamForwarder
    extends Thread {
        private final InputStream mIn;
        private final OutputStream mOut;

        public StreamForwarder(InputStream inputStream, OutputStream outputStream) {
            this.mIn = inputStream;
            this.mOut = outputStream;
        }

        @Override
        public void run() {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mIn));
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.mOut));
                while ((string = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

