/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.util.Duo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TypeName {
    public final String package_;
    public final String type;
    public final String innerType;
    public final int array;

    public TypeName(String string, String string2, String string3, int n) {
        this.package_ = string;
        this.type = string2;
        this.innerType = string3;
        this.array = n;
    }

    public String getName() {
        return this.getName(false, false);
    }

    public String getName(boolean bl, boolean bl2) {
        String string = (this.package_ == null || bl ? "" : this.package_ + '.') + this.type + (this.innerType != null ? (bl2 ? (char)'$' : '.') + this.innerType : "");
        for (int i = 0; i < this.array; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public String getFilePath(boolean bl) {
        return this.package_.replace('.', File.separatorChar) + File.separatorChar + this.type + (bl && this.isInner() ? "$" + this.innerType : "");
    }

    public boolean isInner() {
        return this.innerType != null;
    }

    public String toString() {
        return this.getName();
    }

    public static TypeName fromInternalName(String string) throws AndrolibException {
        Duo<TypeName, Integer> duo = TypeName.fetchFromInternalName(string);
        if (((Integer)duo.m2).intValue() != string.length()) {
            throw new AndrolibException("Invalid internal name: " + string);
        }
        return (TypeName)duo.m1;
    }

    public static List<TypeName> listFromInternalName(String string) throws AndrolibException {
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
        while (!string.isEmpty()) {
            Duo<TypeName, Integer> duo = TypeName.fetchFromInternalName(string);
            arrayList.add((TypeName)duo.m1);
            string = string.substring((Integer)duo.m2);
        }
        return arrayList;
    }

    public static Duo<TypeName, Integer> fetchFromInternalName(String string) throws AndrolibException {
        String string2 = string;
        int n = 0;
        boolean bl = false;
        do {
            if (string.isEmpty()) {
                throw new AndrolibException("Invalid internal name: " + string2);
            }
            boolean bl2 = bl = string.charAt(0) == '[';
            if (!bl) continue;
            ++n;
            string = string.substring(1);
        } while (bl);
        int n2 = n + 1;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        switch (string.charAt(0)) {
            case 'B': {
                string4 = "byte";
                break;
            }
            case 'C': {
                string4 = "char";
                break;
            }
            case 'D': {
                string4 = "double";
                break;
            }
            case 'F': {
                string4 = "float";
                break;
            }
            case 'I': {
                string4 = "int";
                break;
            }
            case 'J': {
                string4 = "long";
                break;
            }
            case 'S': {
                string4 = "short";
                break;
            }
            case 'Z': {
                string4 = "boolean";
                break;
            }
            case 'V': {
                string4 = "void";
                break;
            }
            case 'L': {
                int n3 = string.indexOf(59);
                if (n3 == -1) {
                    throw new AndrolibException("Invalid internal name: " + string2);
                }
                n2 += n3;
                if ((n3 = (string = string.substring(1, n3)).lastIndexOf(47)) == -1) {
                    string3 = "";
                    string4 = string;
                } else {
                    string3 = string.substring(0, n3).replace('/', '.');
                    string4 = string.substring(n3 + 1);
                }
                n3 = string4.indexOf(36);
                if (n3 == -1) break;
                string5 = string4.substring(n3 + 1);
                string4 = string4.substring(0, n3);
                break;
            }
            default: {
                throw new AndrolibException("Invalid internal name: " + string2);
            }
        }
        return new Duo<TypeName, Integer>(new TypeName(string3, string4, string5, n), n2);
    }
}

