/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.src.TypeName;
import brut.androlib.src.mod.IndentingWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.DexFile;

public class SmaliDecoder {
    private final File mApkFile;
    private final File mOutDir;
    private final boolean mDebug;

    public static void decode(File file, File file2, boolean bl) throws AndrolibException {
        new SmaliDecoder(file, file2, bl).decode();
    }

    private SmaliDecoder(File file, File file2, boolean bl) {
        this.mApkFile = file;
        this.mOutDir = file2;
        this.mDebug = bl;
    }

    private void decode() throws AndrolibException {
        try {
            baksmali.useLocalsDirective = true;
            baksmali.useSequentialLabels = true;
            if (this.mDebug) {
                baksmali.registerInfo = 128;
                ClassPath.dontLoadClassPath = true;
            }
            DexFile dexFile = new DexFile(this.mApkFile);
            for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
                this.decodeClassDefItem(classDefItem);
            }
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    private void decodeClassDefItem(ClassDefItem classDefItem) throws AndrolibException, IOException {
        TypeName typeName = TypeName.fromInternalName(classDefItem.getClassType().getTypeDescriptor());
        File file = new File(this.mOutDir, typeName.getFilePath(true) + (this.mDebug ? ".java" : ".smali"));
        if (file.exists()) {
            throw new AndrolibException("File already exists: " + file);
        }
        file.getParentFile().mkdirs();
        IndentingWriter indentingWriter = new IndentingWriter(new FileWriter(file));
        if (this.mDebug) {
            indentingWriter.write("package " + typeName.package_ + "; class " + typeName.getName(true, true) + " {/*\n\n");
        }
        new ClassDefinition(classDefItem).writeTo(indentingWriter);
        if (this.mDebug) {
            indentingWriter.write("\n*/}\n");
        }
        indentingWriter.close();
    }
}

