/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.DebugInjector;
import brut.androlib.src.DexFileBuilder;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;

public class SmaliBuilder {
    private final ExtFile mSmaliDir;
    private final File mDexFile;
    private final boolean mDebug;
    private DexFileBuilder mDexBuilder;

    public static void build(ExtFile extFile, File file, boolean bl) throws AndrolibException {
        new SmaliBuilder(extFile, file, bl).build();
    }

    private SmaliBuilder(ExtFile extFile, File file, boolean bl) {
        this.mSmaliDir = extFile;
        this.mDexFile = file;
        this.mDebug = bl;
    }

    private void build() throws AndrolibException {
        try {
            this.mDexBuilder = new DexFileBuilder();
            for (String string : this.mSmaliDir.getDirectory().getFiles(true)) {
                this.buildFile(string);
            }
            this.mDexBuilder.writeTo(this.mDexFile);
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    private void buildFile(String string) throws AndrolibException, IOException {
        File file = new File(this.mSmaliDir, string);
        FileInputStream fileInputStream = new FileInputStream(file);
        if (string.endsWith(".smali")) {
            this.mDexBuilder.addSmaliFile(file);
            return;
        }
        if (!string.endsWith(".java")) {
            throw new AndrolibException("Unknown file type: " + file);
        }
        StringBuilder stringBuilder = new StringBuilder();
        List list = IOUtils.readLines(fileInputStream);
        if (!this.mDebug) {
            String[] stringArray = list.toArray(new String[0]);
            for (int i = 2; i < stringArray.length - 2; ++i) {
                stringBuilder.append(stringArray[i]).append('\n');
            }
        } else {
            list.remove(list.size() - 1);
            list.remove(list.size() - 1);
            ListIterator<String> listIterator = list.listIterator(2);
            stringBuilder.append(".source \"").append(file.getName()).append("\"\n");
            while (listIterator.hasNext()) {
                String string2 = ((String)listIterator.next()).trim();
                if (string2.isEmpty() || string2.charAt(0) == '#' || string2.startsWith(".source")) continue;
                if (string2.startsWith(".method ")) {
                    listIterator.previous();
                    DebugInjector.inject(listIterator, stringBuilder);
                    continue;
                }
                stringBuilder.append(string2).append('\n');
            }
        }
        this.mDexBuilder.addSmaliFile(IOUtils.toInputStream(stringBuilder.toString()), string);
    }
}

