/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import brut.androlib.AndrolibException;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.StringBlock;
import brut.util.ExtDataInput;
import com.mindprod.ledatastream.LEDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParserException;

public class AXmlResourceParser
implements XmlResourceParser {
    private ExtDataInput m_reader;
    private ResAttrDecoder mAttrDecoder;
    private AndrolibException mFirstError;
    private boolean m_operational = false;
    private StringBlock m_strings;
    private int[] m_resourceIDs;
    private NamespaceStack m_namespaces = new NamespaceStack();
    private boolean m_decreaseDepth;
    private int m_event;
    private int m_lineNumber;
    private int m_name;
    private int m_namespaceUri;
    private int[] m_attributes;
    private int m_idAttribute;
    private int m_classAttribute;
    private int m_styleAttribute;
    private static final Logger LOGGER = Logger.getLogger(AXmlResourceParser.class.getName());

    public AXmlResourceParser() {
        this.resetEventInfo();
    }

    public AndrolibException getFirstError() {
        return this.mFirstError;
    }

    public ResAttrDecoder getAttrDecoder() {
        return this.mAttrDecoder;
    }

    public void setAttrDecoder(ResAttrDecoder resAttrDecoder) {
        this.mAttrDecoder = resAttrDecoder;
    }

    public void open(InputStream inputStream) {
        this.close();
        if (inputStream != null) {
            this.m_reader = new ExtDataInput(new LEDataInputStream(inputStream));
        }
    }

    public void close() {
        if (!this.m_operational) {
            return;
        }
        this.m_operational = false;
        this.m_reader = null;
        this.m_strings = null;
        this.m_resourceIDs = null;
        this.m_namespaces.reset();
        this.resetEventInfo();
    }

    public int next() throws XmlPullParserException, IOException {
        if (this.m_reader == null) {
            throw new XmlPullParserException("Parser is not opened.", this, null);
        }
        try {
            this.doNext();
            return this.m_event;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return this.next();
    }

    @Override
    public int getDepth() {
        return this.m_namespaces.getDepth() - 1;
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        return this.m_event;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    @Override
    public String getName() {
        if (this.m_name == -1 || this.m_event != 2 && this.m_event != 3) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    @Override
    public String getText() {
        if (this.m_name == -1 || this.m_event != 4) {
            return null;
        }
        return this.m_strings.getString(this.m_name);
    }

    @Override
    public String getNamespace() {
        return this.m_strings.getString(this.m_namespaceUri);
    }

    @Override
    public String getPositionDescription() {
        return "XML line #" + this.getLineNumber();
    }

    @Override
    public int getNamespaceCount(int n) throws XmlPullParserException {
        return this.m_namespaces.getAccumulatedCount(n);
    }

    @Override
    public String getNamespacePrefix(int n) throws XmlPullParserException {
        int n2 = this.m_namespaces.getPrefix(n);
        return this.m_strings.getString(n2);
    }

    @Override
    public String getNamespaceUri(int n) throws XmlPullParserException {
        int n2 = this.m_namespaces.getUri(n);
        return this.m_strings.getString(n2);
    }

    @Override
    public int getAttributeCount() {
        if (this.m_event != 2) {
            return -1;
        }
        return this.m_attributes.length / 5;
    }

    @Override
    public String getAttributeNamespace(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 0];
        if (n3 == -1) {
            return "";
        }
        return this.m_strings.getString(n3);
    }

    public String getAttributePrefix(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 0];
        int n4 = this.m_namespaces.findPrefix(n3);
        if (n4 == -1) {
            return "";
        }
        return this.m_strings.getString(n4);
    }

    @Override
    public String getAttributeName(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 1];
        if (n3 == -1) {
            return "";
        }
        return this.m_strings.getString(n3);
    }

    public int getAttributeNameResource(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 1];
        if (this.m_resourceIDs == null || n3 < 0 || n3 >= this.m_resourceIDs.length) {
            return 0;
        }
        return this.m_resourceIDs[n3];
    }

    @Override
    public String getAttributeValue(int n) {
        int n2 = this.getAttributeOffset(n);
        int n3 = this.m_attributes[n2 + 3];
        if (n3 == 3) {
            int n4 = this.m_attributes[n2 + 2];
            return AndrolibResources.escapeTextForResXml(this.m_strings.getString(n4));
        }
        int n5 = this.m_attributes[n2 + 4];
        if (this.mAttrDecoder != null) {
            try {
                return this.mAttrDecoder.decode(n3, n5, this.getAttributeNameResource(n));
            }
            catch (AndrolibException androlibException) {
                this.setFirstError(androlibException);
                LOGGER.log(Level.WARNING, String.format("Could not decode attr value, using undecoded value instead: ns=%s, name=%s, value=0x%08x", this.getAttributePrefix(n), this.getAttributeName(n), n5), androlibException);
            }
        }
        return TypedValue.coerceToString(n3, n5);
    }

    @Override
    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        this.open(inputStream);
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Object getProperty(String string) {
        return null;
    }

    @Override
    public boolean getFeature(String string) {
        return false;
    }

    private final int getAttributeOffset(int n) {
        if (this.m_event != 2) {
            throw new IndexOutOfBoundsException("Current event is not START_TAG.");
        }
        int n2 = n * 5;
        if (n2 >= this.m_attributes.length) {
            throw new IndexOutOfBoundsException("Invalid attribute index (" + n + ").");
        }
        return n2;
    }

    private final void resetEventInfo() {
        this.m_event = -1;
        this.m_lineNumber = -1;
        this.m_name = -1;
        this.m_namespaceUri = -1;
        this.m_attributes = null;
        this.m_idAttribute = -1;
        this.m_classAttribute = -1;
        this.m_styleAttribute = -1;
    }

    private final void doNext() throws IOException {
        block14: {
            if (this.m_strings == null) {
                this.m_reader.skipCheckInt(524291);
                this.m_reader.skipInt();
                this.m_strings = StringBlock.read(this.m_reader);
                this.m_namespaces.increaseDepth();
                this.m_operational = true;
            }
            if (this.m_event == 1) {
                return;
            }
            int n = this.m_event;
            this.resetEventInfo();
            while (true) {
                int n2;
                int n3;
                int n4;
                if (this.m_decreaseDepth) {
                    this.m_decreaseDepth = false;
                    this.m_namespaces.decreaseDepth();
                }
                if (n == 3 && this.m_namespaces.getDepth() == 1 && this.m_namespaces.getCurrentCount() == 0) {
                    this.m_event = 1;
                    break block14;
                }
                int n5 = n == 0 ? 0x100102 : this.m_reader.readInt();
                if (n5 == 524672) {
                    n4 = this.m_reader.readInt();
                    if (n4 < 8 || n4 % 4 != 0) {
                        throw new IOException("Invalid resource ids size (" + n4 + ").");
                    }
                    this.m_resourceIDs = this.m_reader.readIntArray(n4 / 4 - 2);
                    continue;
                }
                if (n5 < 0x100100 || n5 > 0x100104) {
                    throw new IOException("Invalid chunk type (" + n5 + ").");
                }
                if (n5 == 0x100102 && n == -1) {
                    this.m_event = 0;
                    break block14;
                }
                this.m_reader.skipInt();
                n4 = this.m_reader.readInt();
                this.m_reader.skipInt();
                if (n5 == 0x100100 || n5 == 0x100101) {
                    if (n5 == 0x100100) {
                        n3 = this.m_reader.readInt();
                        n2 = this.m_reader.readInt();
                        this.m_namespaces.push(n3, n2);
                        continue;
                    }
                    this.m_reader.skipInt();
                    this.m_reader.skipInt();
                    this.m_namespaces.pop();
                    continue;
                }
                this.m_lineNumber = n4;
                if (n5 == 0x100102) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_reader.skipInt();
                    n3 = this.m_reader.readInt();
                    this.m_idAttribute = (n3 >>> 16) - 1;
                    this.m_classAttribute = this.m_reader.readInt();
                    this.m_styleAttribute = (this.m_classAttribute >>> 16) - 1;
                    this.m_classAttribute = (this.m_classAttribute & 0xFFFF) - 1;
                    this.m_attributes = this.m_reader.readIntArray((n3 &= 0xFFFF) * 5);
                    for (n2 = 3; n2 < this.m_attributes.length; n2 += 5) {
                        this.m_attributes[n2] = this.m_attributes[n2] >>> 24;
                    }
                    this.m_namespaces.increaseDepth();
                    this.m_event = 2;
                    break block14;
                }
                if (n5 == 0x100103) {
                    this.m_namespaceUri = this.m_reader.readInt();
                    this.m_name = this.m_reader.readInt();
                    this.m_event = 3;
                    this.m_decreaseDepth = true;
                    break block14;
                }
                if (n5 == 0x100104) break;
            }
            this.m_name = this.m_reader.readInt();
            this.m_reader.skipInt();
            this.m_reader.skipInt();
            this.m_event = 4;
        }
    }

    private void setFirstError(AndrolibException androlibException) {
        if (this.mFirstError == null) {
            this.mFirstError = androlibException;
        }
    }

    private static final class NamespaceStack {
        private int[] m_data = new int[32];
        private int m_dataLength;
        private int m_count;
        private int m_depth;

        public final void reset() {
            this.m_dataLength = 0;
            this.m_count = 0;
            this.m_depth = 0;
        }

        public final int getCurrentCount() {
            if (this.m_dataLength == 0) {
                return 0;
            }
            int n = this.m_dataLength - 1;
            return this.m_data[n];
        }

        public final int getAccumulatedCount(int n) {
            if (this.m_dataLength == 0 || n < 0) {
                return 0;
            }
            if (n > this.m_depth) {
                n = this.m_depth;
            }
            int n2 = 0;
            int n3 = 0;
            while (n != 0) {
                int n4 = this.m_data[n3];
                n2 += n4;
                n3 += 2 + n4 * 2;
                --n;
            }
            return n2;
        }

        public final void push(int n, int n2) {
            if (this.m_depth == 0) {
                this.increaseDepth();
            }
            this.ensureDataCapacity(2);
            int n3 = this.m_dataLength - 1;
            int n4 = this.m_data[n3];
            this.m_data[n3 - 1 - n4 * 2] = n4 + 1;
            this.m_data[n3] = n;
            this.m_data[n3 + 1] = n2;
            this.m_data[n3 + 2] = n4 + 1;
            this.m_dataLength += 2;
            ++this.m_count;
        }

        public final boolean pop() {
            if (this.m_dataLength == 0) {
                return false;
            }
            int n = this.m_dataLength - 1;
            int n2 = this.m_data[n];
            if (n2 == 0) {
                return false;
            }
            this.m_data[n -= 2] = --n2;
            this.m_data[n -= 1 + n2 * 2] = n2;
            this.m_dataLength -= 2;
            --this.m_count;
            return true;
        }

        public final int getPrefix(int n) {
            return this.get(n, true);
        }

        public final int getUri(int n) {
            return this.get(n, false);
        }

        public final int findPrefix(int n) {
            return this.find(n, false);
        }

        public final int getDepth() {
            return this.m_depth;
        }

        public final void increaseDepth() {
            this.ensureDataCapacity(2);
            int n = this.m_dataLength;
            this.m_data[n] = 0;
            this.m_data[n + 1] = 0;
            this.m_dataLength += 2;
            ++this.m_depth;
        }

        public final void decreaseDepth() {
            if (this.m_dataLength == 0) {
                return;
            }
            int n = this.m_dataLength - 1;
            int n2 = this.m_data[n];
            if (n - 1 - n2 * 2 == 0) {
                return;
            }
            this.m_dataLength -= 2 + n2 * 2;
            this.m_count -= n2;
            --this.m_depth;
        }

        private void ensureDataCapacity(int n) {
            int n2 = this.m_data.length - this.m_dataLength;
            if (n2 > n) {
                return;
            }
            int n3 = (this.m_data.length + n2) * 2;
            int[] nArray = new int[n3];
            System.arraycopy(this.m_data, 0, nArray, 0, this.m_dataLength);
            this.m_data = nArray;
        }

        private final int find(int n, boolean bl) {
            if (this.m_dataLength == 0) {
                return -1;
            }
            int n2 = this.m_dataLength - 1;
            for (int i = this.m_depth; i != 0; --i) {
                int n3 = this.m_data[n2];
                n2 -= 2;
                while (n3 != 0) {
                    if (bl) {
                        if (this.m_data[n2] == n) {
                            return this.m_data[n2 + 1];
                        }
                    } else if (this.m_data[n2 + 1] == n) {
                        return this.m_data[n2];
                    }
                    n2 -= 2;
                    --n3;
                }
            }
            return -1;
        }

        private final int get(int n, boolean bl) {
            if (this.m_dataLength == 0 || n < 0) {
                return -1;
            }
            int n2 = 0;
            for (int i = this.m_depth; i != 0; --i) {
                int n3 = this.m_data[n2];
                if (n >= n3) {
                    n -= n3;
                    n2 += 2 + n3 * 2;
                    continue;
                }
                n2 += 1 + n * 2;
                if (!bl) {
                    ++n2;
                }
                return this.m_data[n2];
            }
            return -1;
        }
    }
}

