/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResResSpec {
    private final ResID mId;
    private final String mName;
    private final ResPackage mPackage;
    private final ResType mType;
    private final Map<ResConfigFlags, ResResource> mResources = new LinkedHashMap<ResConfigFlags, ResResource>();

    public ResResSpec(ResID resID, String string, ResPackage resPackage, ResType resType) {
        this.mId = resID;
        this.mName = string;
        this.mPackage = resPackage;
        this.mType = resType;
    }

    public ResResource getResource(ResConfigFlags resConfigFlags) throws AndrolibException {
        ResResource resResource = this.mResources.get(resConfigFlags);
        if (resResource == null) {
            throw new UndefinedResObject(String.format("resource: spec=%s, config=%s", this, resConfigFlags));
        }
        return resResource;
    }

    public ResResource getDefaultResource() throws AndrolibException {
        return this.getResource(new ResConfigFlags());
    }

    public boolean hasDefaultResource() {
        return this.mResources.containsKey(new ResConfigFlags());
    }

    public String getFullName(ResPackage resPackage, boolean bl) {
        return this.getFullName(this.getPackage().equals(resPackage), bl);
    }

    public String getFullName(boolean bl, boolean bl2) {
        return (bl ? "" : this.getPackage().getName() + ":") + (bl2 ? "" : this.getType().getName() + "/") + this.getName();
    }

    public ResID getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public ResPackage getPackage() {
        return this.mPackage;
    }

    public ResType getType() {
        return this.mType;
    }

    public void addResource(ResResource resResource) throws AndrolibException {
        ResConfigFlags resConfigFlags = resResource.getConfig().getFlags();
        if (this.mResources.put(resConfigFlags, resResource) != null) {
            throw new AndrolibException(String.format("Multiple resources: spec=%s, config=%s", this, resConfigFlags));
        }
    }

    public String toString() {
        return this.mId.toString() + " " + this.mType.toString() + "/" + this.mName;
    }
}

