/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.err.OutDirExistsException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.util.OS;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ApkDecoder {
    private final Androlib mAndrolib;
    private ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;
    private boolean mDebug = false;
    private boolean mForceDelete = false;
    private String mFrameTag;

    public ApkDecoder() {
        this(new Androlib());
    }

    public ApkDecoder(Androlib androlib) {
        this.mAndrolib = androlib;
    }

    public void setApkFile(File file) {
        this.mApkFile = new ExtFile(file);
        this.mResTable = null;
    }

    public void setOutDir(File file) throws AndrolibException {
        this.mOutDir = file;
    }

    public void decode() throws AndrolibException {
        File file = this.getOutDir();
        if (!this.mForceDelete && file.exists()) {
            throw new OutDirExistsException();
        }
        try {
            OS.rmdir(file);
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
        file.mkdirs();
        if (this.hasSources()) {
            switch (this.mDecodeSources) {
                case 0: {
                    this.mAndrolib.decodeSourcesRaw(this.mApkFile, file, this.mDebug);
                    break;
                }
                case 1: {
                    this.mAndrolib.decodeSourcesSmali(this.mApkFile, file, this.mDebug);
                    break;
                }
                case 2: {
                    this.mAndrolib.decodeSourcesJava(this.mApkFile, file, this.mDebug);
                }
            }
        }
        if (this.hasResources()) {
            switch (this.mDecodeResources) {
                case 256: {
                    this.mAndrolib.decodeResourcesRaw(this.mApkFile, file);
                    break;
                }
                case 257: {
                    this.mAndrolib.decodeResourcesFull(this.mApkFile, file, this.getResTable());
                }
            }
        }
        this.mAndrolib.decodeRawFiles(this.mApkFile, file);
        this.writeMetaFile();
    }

    public void setDecodeSources(short s) throws AndrolibException {
        if (s != 0 && s != 1 && s != 2) {
            throw new AndrolibException("Invalid decode sources mode: " + s);
        }
        this.mDecodeSources = s;
    }

    public void setDecodeResources(short s) throws AndrolibException {
        if (s != 256 && s != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.mDecodeResources = s;
    }

    public void setDebugMode(boolean bl) {
        this.mDebug = bl;
    }

    public void setForceDelete(boolean bl) {
        this.mForceDelete = bl;
    }

    public void setFrameworkTag(String string) throws AndrolibException {
        this.mFrameTag = string;
        if (this.mResTable != null) {
            this.getResTable().setFrameTag(string);
        }
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            if (!this.hasResources()) {
                throw new AndrolibException("Apk doesn't containt resources.arsc file");
            }
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile);
            this.mResTable.setFrameTag(this.mFrameTag);
        }
        return this.mResTable;
    }

    public boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }

    private void writeMetaFile() throws AndrolibException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("version", Androlib.getVersion());
        linkedHashMap.put("apkFileName", this.mApkFile.getName());
        if (this.hasResources()) {
            linkedHashMap.put("isFrameworkApk", this.mAndrolib.isFrameworkApk(this.getResTable()));
            this.putUsesFramework(linkedHashMap);
        }
        this.mAndrolib.writeMetaFile(this.mOutDir, linkedHashMap);
    }

    private void putUsesFramework(Map<String, Object> map) throws AndrolibException {
        Set<ResPackage> set = this.getResTable().listFramePackages();
        if (set.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[set.size()];
        int n = 0;
        for (ResPackage resPackage : set) {
            integerArray[n++] = resPackage.getId();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("ids", integerArray);
        if (this.mFrameTag != null) {
            linkedHashMap.put("tag", this.mFrameTag);
        }
        map.put("usesFramework", linkedHashMap);
    }
}

