/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public class TypedValue {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};

    public static float complexToFloat(int n) {
        return (float)(n & 0xFFFFFF00) * RADIX_MULTS[n >> 4 & 3];
    }

    public static final String coerceToString(int n, int n2) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return "@" + n2;
            }
            case 2: {
                return "?" + n2;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(n2));
            }
            case 5: {
                return Float.toString(TypedValue.complexToFloat(n2)) + DIMENSION_UNIT_STRS[n2 >> 0 & 0xF];
            }
            case 6: {
                return Float.toString(TypedValue.complexToFloat(n2) * 100.0f) + FRACTION_UNIT_STRS[n2 >> 0 & 0xF];
            }
            case 17: {
                return "0x" + Integer.toHexString(n2);
            }
            case 18: {
                return n2 != 0 ? "true" : "false";
            }
        }
        if (n >= 28 && n <= 31) {
            return "#" + Integer.toHexString(n2);
        }
        if (n >= 16 && n <= 31) {
            return Integer.toString(n2);
        }
        return null;
    }
}

