# AnyKernel2 Ramdisk Mod Script
# osm0sis @ xda-developers

## AnyKernel setup
# EDIFY properties
kernel.string="Anti-root removal for G6 Oreo"
do.devicecheck=1
do.modules=0 # we will do it ourself.
do.cleanup=1
do.cleanuponabort=0
device.name1=lucye
device.name2=us997
device.name3=h870
device.name4=
device.name5=

# shell variables
block=/dev/block/bootdevice/by-name/boot;
is_slot_device=0;
force_seandroid=1;

## AnyKernel methods (DO NOT CHANGE)
# import patching functions/variables - see for reference
. /tmp/anykernel/tools/ak2-core.sh;

## zefie kernel info

ui_print "If nothing appears below, then you are already patched."

## AnyKernel install

# Dump initrd
dump_boot;
PATCHED=0

# remove /sbin/rctd if it exists
if [ -f "$ramdisk/sbin/rctd" ]; then
	PATCHED=1
	ui_print "Removing /sbin/rctd..."
	rm -f "$ramdisk/sbin/rctd"
fi

if [ -f "$ramdisk/init.lge.rc" ]; then
	if [ "$(grep /sbin/rctd $ramdisk/init.lge.rc | wc -l)" -gt "0" ]; then
		PATCHED=1
		ui_print "Removing rctd service from init.lge.rc..."
		sed -ie '/\/sbin\/rctd/,+4d' "$ramdisk/init.lge.rc"
	fi
fi

if [ -f "$ramdisk/fstab.lucye" ]; then
	if [ "$(grep forceencrypt $ramdisk/fstab.lucye | wc -l)" -gt "0" ] ||
	[ "$(grep encryptable $ramdisk/fstab.lucye | wc -l)" -gt "0" ]; then
		PATCHED=1
		ui_print "Disabling encryption..."
		sed -ie 's/forceencrypt/encryptable/' "$ramdisk/fstab.lucye"
	fi
fi

if [ -f "$ramdisk/init.rc" ]; then
	if [ "$(grep /system/bin/install-recovery $ramdisk/init.rc | wc -l)" -gt "0" ]; then
		PATCHED=1
		ui_print "Removing custom recovery killer..."
		sed -ie '/\/system\/bin\/install-recovery/,+2d' "$ramdisk/init.rc"
	fi
fi

if [ $PATCHED -eq 1 ]; then
	ui_print "Success. Writing boot...";
	write_boot;
	sync;
else
	ui_print "No patch needed, not reflashing boot."
fi
## end install
