/*
 * Decompiled with CFR 0.152.
 */
package psndl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Downloader
implements Runnable {
    private static final String[] STATUSES = new String[]{"Downloading", "Finished", "Paused", "Stopped", "Error"};
    private static final int DOWNLOADING = 0;
    private static final int FINISHED = 1;
    private static final int PAUSED = 2;
    private static final int STOPPED = 3;
    private static final int ERROR = 4;
    private static final int MAX_BUFFER_SIZE = 1024;
    private URL url;
    private long size;
    private long downloaded;
    private long downloadedSinceRunning;
    private long resumeTime;
    private int status;
    private String customFileName = null;
    private String dest = null;

    public Downloader(String URL2, String dest, String fileName) {
        try {
            this.url = new URL(URL2);
            this.customFileName = fileName;
            this.dest = dest;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Downloader.class.getName()).log(Level.SEVERE, null, ex);
            this.status = 4;
        }
        this.size = -1L;
        this.downloaded = 0L;
    }

    public int getPercentProgress() {
        return (int)((float)this.downloaded / (float)this.size * 100.0f);
    }

    public float getSize() {
        DecimalFormat df = new DecimalFormat("#.#");
        return Float.parseFloat(df.format((float)this.size / 1024.0f / 1024.0f).replace(",", "."));
    }

    public float getDownloadedSize() {
        DecimalFormat df = new DecimalFormat("#.#");
        return Float.parseFloat(df.format((float)this.downloaded / 1024.0f / 1024.0f).replace(",", "."));
    }

    public void startDownload() {
        if (this.status == 3) {
            return;
        }
        this.status = 0;
        this.resumeTime = System.currentTimeMillis();
        this.downloadedSinceRunning = 0L;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void pause() {
        if (this.status != 0) {
            return;
        }
        this.status = 2;
    }

    public void resume() {
        if (this.status == 0 || this.status == 3) {
            return;
        }
        this.startDownload();
    }

    public void cancel() {
        this.status = 3;
        this.url = null;
        final File file = new File(this.dest + this.getFileName());
        Timer timer_delete_file = new Timer();
        timer_delete_file.schedule(new TimerTask(){

            @Override
            public void run() {
                while (!file.delete()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, 100L);
    }

    public String getStatus() {
        return STATUSES[this.status];
    }

    public String getDownloadSpeed() {
        if (this.status != 0) {
            return "0 KB/s";
        }
        long elapsedTime = System.currentTimeMillis() - this.resumeTime;
        double speedKB = this.downloadedSinceRunning / elapsedTime;
        return speedKB < 1024.0 ? String.valueOf(Downloader.round(speedKB, 2)) + " KB/s" : String.valueOf(Downloader.round(speedKB / 1024.0, 2)) + " MB/s";
    }

    private static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile file = null;
        InputStream stream = null;
        try {
            byte[] buffer;
            int read;
            long contentLength;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + this.downloaded + "-");
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                System.out.println("BAD RESPONSE CODE : " + connection.getResponseCode());
                this.error();
            }
            if ((contentLength = connection.getContentLengthLong()) < 1L) {
                this.error();
            }
            if (this.size == -1L) {
                this.size = contentLength;
            }
            file = new RandomAccessFile(this.dest + this.getFileName(), "rw");
            file.seek(this.downloaded);
            stream = connection.getInputStream();
            while (this.status == 0 && (read = stream.read(buffer = this.size - this.downloaded > 1024L ? new byte[1024] : new byte[(int)(this.size - this.downloaded)])) != -1) {
                file.write(buffer, 0, read);
                this.downloaded += (long)read;
                this.downloadedSinceRunning += (long)read;
            }
            if (this.status == 0) {
                this.status = 1;
            }
        }
        catch (IOException e) {
            this.error();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void error() {
        this.status = 4;
    }

    public String getFileName() {
        if (this.customFileName == null || this.customFileName.isEmpty()) {
            String fileName = this.url.getFile();
            return fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        return this.customFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFileSizeFromURL(String urlStr) {
        URL url = new URL(urlStr);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            DecimalFormat df = new DecimalFormat("#.#");
            float f = Float.parseFloat(df.format((float)conn.getContentLengthLong() / 1024.0f / 1024.0f).replace(",", "."));
            if (conn != null) {
                conn.disconnect();
            }
            return f;
        }
        catch (IOException e) {
            try {
                float f = -1.0f;
                if (conn != null) {
                    conn.disconnect();
                }
                return f;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(Downloader.class.getName()).log(Level.SEVERE, null, ex);
                    return -1.0f;
                }
            }
        }
    }
}

